/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite;

import appeng.worldgen.meteorite.CraterType;
import appeng.worldgen.meteorite.MeteoriteStructurePiece;
import appeng.worldgen.meteorite.fallout.FalloutMode;
import com.google.common.math.StatsAccumulator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class MeteoriteStructureStart
extends StructureStart {
    private final Tag<Block> sandTag = BlockTags.func_199896_a().func_199915_b(new ResourceLocation("minecraft:sand"));
    private final Tag<Block> terracottaTag = BlockTags.func_199896_a().func_199915_b(new ResourceLocation("forge:terracotta"));

    public MeteoriteStructureStart(Structure<?> p_i225815_1_, int p_i225815_2_, int p_i225815_3_, MutableBoundingBox p_i225815_4_, int p_i225815_5_, long p_i225815_6_) {
        super(p_i225815_1_, p_i225815_2_, p_i225815_3_, p_i225815_4_, p_i225815_5_, p_i225815_6_);
    }

    public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biome) {
        int centerX = chunkX * 16 + this.field_214631_d.nextInt(16);
        int centerZ = chunkZ * 16 + this.field_214631_d.nextInt(16);
        float meteoriteRadius = this.field_214631_d.nextFloat() * 6.0f + 2.0f;
        int yOffset = (int)Math.ceil(meteoriteRadius) + 1;
        Set t2 = generator.func_202090_b().func_225530_a_(centerX, 0, centerZ, 0);
        Biome spawnBiome = t2.stream().findFirst().orElse(biome);
        boolean isOcean = spawnBiome.func_201856_r() == Biome.Category.OCEAN;
        Heightmap.Type heightmapType = isOcean ? Heightmap.Type.OCEAN_FLOOR_WG : Heightmap.Type.WORLD_SURFACE_WG;
        StatsAccumulator stats = new StatsAccumulator();
        int scanRadius = (int)Math.max(1.0f, meteoriteRadius * 2.0f);
        for (int x = -scanRadius; x <= scanRadius; ++x) {
            for (int z = -scanRadius; z <= scanRadius; ++z) {
                int h = generator.func_222529_a(centerX + x, centerZ + z, heightmapType);
                stats.add((double)h);
            }
        }
        int centerY = (int)stats.mean();
        if (stats.populationVariance() > 5.0) {
            centerY = (int)((double)centerY - (stats.mean() - stats.min()) * 0.75);
        }
        centerY -= yOffset;
        centerY = Math.max(32, centerY);
        BlockPos actualPos = new BlockPos(centerX, centerY, centerZ);
        boolean craterLake = this.locateWaterAroundTheCrater(generator, actualPos, meteoriteRadius);
        CraterType craterType = this.determineCraterType(spawnBiome);
        boolean pureCrater = this.field_214631_d.nextFloat() > 0.9f;
        FalloutMode fallout = this.getFalloutFromBaseBlock(spawnBiome.func_203944_q().func_204108_a());
        this.field_75075_a.add(new MeteoriteStructurePiece(actualPos, meteoriteRadius, craterType, fallout, pureCrater, craterLake));
        this.func_202500_a();
    }

    private boolean locateWaterAroundTheCrater(ChunkGenerator<?> generator, BlockPos pos, float radius) {
        int seaLevel = generator.func_222530_f();
        int maxY = seaLevel - 1;
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        blockPos.func_185336_p(maxY);
        for (int i = pos.func_177958_n() - 32; i <= pos.func_177958_n() + 32; ++i) {
            blockPos.func_223471_o(i);
            for (int k = pos.func_177952_p() - 32; k <= pos.func_177952_p() + 32; ++k) {
                int heigth;
                blockPos.func_223472_q(k);
                double dx = i - pos.func_177958_n();
                double dz = k - pos.func_177952_p();
                double h = (float)pos.func_177956_o() - radius + 1.0f;
                double distanceFrom = dx * dx + dz * dz;
                if (!((double)maxY > h + distanceFrom * 0.0175) || !((double)maxY < h + distanceFrom * 0.02) || (heigth = generator.func_222529_a(blockPos.func_177958_n(), blockPos.func_177952_p(), Heightmap.Type.OCEAN_FLOOR)) >= seaLevel) continue;
                return true;
            }
        }
        return false;
    }

    private CraterType determineCraterType(Biome biome) {
        boolean lava;
        boolean lake;
        boolean specialMeteor;
        Biome.TempCategory temp = biome.func_150561_m();
        Biome.Category category = biome.func_201856_r();
        if (category == Biome.Category.OCEAN) {
            return CraterType.NONE;
        }
        boolean bl = specialMeteor = this.field_214631_d.nextFloat() > 0.5f;
        if (!specialMeteor) {
            return CraterType.NORMAL;
        }
        if (temp == Biome.TempCategory.WARM) {
            boolean lava2 = this.field_214631_d.nextFloat() > 0.5f;
            switch (biome.func_201851_b()) {
                case NONE: {
                    return lava2 ? CraterType.LAVA : CraterType.NORMAL;
                }
                case RAIN: {
                    boolean obsidian = this.field_214631_d.nextFloat() > 0.75f;
                    CraterType alternativObsidian = obsidian ? CraterType.OBSIDIAN : CraterType.LAVA;
                    return lava2 ? alternativObsidian : CraterType.NORMAL;
                }
            }
        }
        if (temp == Biome.TempCategory.MEDIUM) {
            lake = this.field_214631_d.nextFloat() > 0.25f;
            lava = this.field_214631_d.nextFloat() > 0.8f;
            switch (biome.func_201851_b()) {
                case NONE: {
                    return lava ? CraterType.LAVA : CraterType.NORMAL;
                }
                case RAIN: {
                    boolean obsidian = this.field_214631_d.nextFloat() > 0.75f;
                    CraterType alternativObsidian = obsidian ? CraterType.OBSIDIAN : CraterType.LAVA;
                    CraterType craterLake = lake ? CraterType.WATER : CraterType.NORMAL;
                    return lava ? alternativObsidian : craterLake;
                }
                case SNOW: {
                    boolean snow = this.field_214631_d.nextFloat() > 0.75f;
                    CraterType water = lake ? CraterType.WATER : CraterType.NORMAL;
                    return snow ? CraterType.SNOW : water;
                }
            }
        }
        if (temp == Biome.TempCategory.COLD) {
            lake = this.field_214631_d.nextFloat() > 0.25f;
            lava = this.field_214631_d.nextFloat() > 0.95f;
            boolean frozen = this.field_214631_d.nextFloat() > 0.25f;
            switch (biome.func_201851_b()) {
                case NONE: {
                    return lava ? CraterType.LAVA : CraterType.NORMAL;
                }
                case RAIN: {
                    CraterType frozenLake = frozen ? CraterType.ICE : CraterType.WATER;
                    CraterType craterLake = lake ? frozenLake : CraterType.NORMAL;
                    return lava ? CraterType.LAVA : craterLake;
                }
                case SNOW: {
                    CraterType snowCovered = lake ? CraterType.SNOW : CraterType.NORMAL;
                    return lava ? CraterType.LAVA : snowCovered;
                }
            }
        }
        return CraterType.NORMAL;
    }

    private FalloutMode getFalloutFromBaseBlock(BlockState blockState) {
        Block block = blockState.func_177230_c();
        if (block.func_203417_a(this.sandTag)) {
            return FalloutMode.SAND;
        }
        if (block.func_203417_a(this.terracottaTag)) {
            return FalloutMode.TERRACOTTA;
        }
        if (block == Blocks.field_150433_aE || block == Blocks.field_150433_aE || block == Blocks.field_196604_cC || block == Blocks.field_150432_aD || block == Blocks.field_150403_cj) {
            return FalloutMode.ICE_SNOW;
        }
        return FalloutMode.DEFAULT;
    }
}

