/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.client.texture.FlippableIcon;
import appeng.client.texture.TmpFlippableIcon;
import appeng.tile.AEBaseTile;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockRenderInfo {
    private final BaseBlockRender<? extends AEBaseBlock, ? extends AEBaseTile> rendererInstance;
    private final TmpFlippableIcon tmpTopIcon = new TmpFlippableIcon();
    private final TmpFlippableIcon tmpBottomIcon = new TmpFlippableIcon();
    private final TmpFlippableIcon tmpSouthIcon = new TmpFlippableIcon();
    private final TmpFlippableIcon tmpNorthIcon = new TmpFlippableIcon();
    private final TmpFlippableIcon tmpEastIcon = new TmpFlippableIcon();
    private final TmpFlippableIcon tmpWestIcon = new TmpFlippableIcon();
    private boolean useTmp = false;
    private FlippableIcon topIcon = null;
    private FlippableIcon bottomIcon = null;
    private FlippableIcon southIcon = null;
    private FlippableIcon northIcon = null;
    private FlippableIcon eastIcon = null;
    private FlippableIcon westIcon = null;

    public BlockRenderInfo(BaseBlockRender<? extends AEBaseBlock, ? extends AEBaseTile> inst) {
        this.rendererInstance = inst;
    }

    public void updateIcons(FlippableIcon bottom, FlippableIcon top, FlippableIcon north, FlippableIcon south, FlippableIcon east, FlippableIcon west) {
        this.topIcon = top;
        this.bottomIcon = bottom;
        this.southIcon = south;
        this.northIcon = north;
        this.eastIcon = east;
        this.westIcon = west;
    }

    public void setTemporaryRenderIcon(IIcon icon) {
        if (icon == null) {
            this.useTmp = false;
        } else {
            this.useTmp = true;
            this.tmpTopIcon.setOriginal(icon);
            this.tmpBottomIcon.setOriginal(icon);
            this.tmpSouthIcon.setOriginal(icon);
            this.tmpNorthIcon.setOriginal(icon);
            this.tmpEastIcon.setOriginal(icon);
            this.tmpWestIcon.setOriginal(icon);
        }
    }

    public void setTemporaryRenderIcons(IIcon nTopIcon, IIcon nBottomIcon, IIcon nSouthIcon, IIcon nNorthIcon, IIcon nEastIcon, IIcon nWestIcon) {
        this.tmpTopIcon.setOriginal(nTopIcon == null ? this.getTexture(ForgeDirection.UP) : nTopIcon);
        this.tmpBottomIcon.setOriginal(nBottomIcon == null ? this.getTexture(ForgeDirection.DOWN) : nBottomIcon);
        this.tmpSouthIcon.setOriginal(nSouthIcon == null ? this.getTexture(ForgeDirection.SOUTH) : nSouthIcon);
        this.tmpNorthIcon.setOriginal(nNorthIcon == null ? this.getTexture(ForgeDirection.NORTH) : nNorthIcon);
        this.tmpEastIcon.setOriginal(nEastIcon == null ? this.getTexture(ForgeDirection.EAST) : nEastIcon);
        this.tmpWestIcon.setOriginal(nWestIcon == null ? this.getTexture(ForgeDirection.WEST) : nWestIcon);
        this.useTmp = true;
    }

    public FlippableIcon getTexture(ForgeDirection dir) {
        if (this.useTmp) {
            switch (dir) {
                case DOWN: {
                    return this.tmpBottomIcon;
                }
                case UP: {
                    return this.tmpTopIcon;
                }
                case NORTH: {
                    return this.tmpNorthIcon;
                }
                case SOUTH: {
                    return this.tmpSouthIcon;
                }
                case EAST: {
                    return this.tmpEastIcon;
                }
                case WEST: {
                    return this.tmpWestIcon;
                }
            }
        }
        switch (dir) {
            case DOWN: {
                return this.bottomIcon;
            }
            case UP: {
                return this.topIcon;
            }
            case NORTH: {
                return this.northIcon;
            }
            case SOUTH: {
                return this.southIcon;
            }
            case EAST: {
                return this.eastIcon;
            }
            case WEST: {
                return this.westIcon;
            }
        }
        return this.topIcon;
    }

    boolean isValid() {
        return this.topIcon != null && this.bottomIcon != null && this.southIcon != null && this.northIcon != null && this.eastIcon != null && this.westIcon != null;
    }

    public BaseBlockRender getRendererInstance() {
        return this.rendererInstance;
    }
}

