/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.api.definitions.IItemDefinition;
import appeng.core.features.ActivityState;
import appeng.util.Platform;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public class ItemDefinition
implements IItemDefinition {
    private final Optional<Item> item;

    public ItemDefinition(Item item, ActivityState state) {
        Preconditions.checkNotNull((Object)item);
        Preconditions.checkNotNull((Object)((Object)state));
        this.item = state == ActivityState.Enabled ? Optional.of((Object)item) : Optional.absent();
    }

    @Override
    public final Optional<Item> maybeItem() {
        return this.item;
    }

    @Override
    public Optional<ItemStack> maybeStack(int stackSize) {
        return this.item.transform((Function)new ItemStackTransformer(stackSize));
    }

    @Override
    public boolean isEnabled() {
        return this.item.isPresent();
    }

    @Override
    public final boolean isSameAs(ItemStack comparableStack) {
        return this.isEnabled() && Platform.isSameItemType(comparableStack, (ItemStack)this.maybeStack(1).get());
    }

    @Override
    public boolean isSameAs(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    private static class ItemStackTransformer
    implements Function<Item, ItemStack> {
        private final int stackSize;

        public ItemStackTransformer(int stackSize) {
            Preconditions.checkArgument((stackSize > 0 ? 1 : 0) != 0);
            this.stackSize = stackSize;
        }

        public ItemStack apply(Item input) {
            return new ItemStack(input, this.stackSize);
        }
    }
}

