/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.api.definitions.IItemDefinition;
import appeng.core.CreativeTab;
import appeng.core.CreativeTabFacade;
import appeng.core.features.AEFeature;
import appeng.core.features.ActivityState;
import appeng.core.features.FeatureNameExtractor;
import appeng.core.features.FeaturedActiveChecker;
import appeng.core.features.IAEFeature;
import appeng.core.features.IFeatureHandler;
import appeng.core.features.ItemDefinition;
import appeng.items.parts.ItemFacade;
import com.google.common.base.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.EnumSet;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;

public final class ItemFeatureHandler
implements IFeatureHandler {
    private final Item item;
    private final FeatureNameExtractor extractor;
    private final boolean enabled;
    private final ItemDefinition definition;

    public ItemFeatureHandler(EnumSet<AEFeature> features, Item item, IAEFeature featured, Optional<String> subName) {
        ActivityState state = new FeaturedActiveChecker(features).getActivityState();
        this.item = item;
        this.extractor = new FeatureNameExtractor(featured.getClass(), subName);
        this.enabled = state == ActivityState.Enabled;
        this.definition = new ItemDefinition(item, state);
    }

    @Override
    public boolean isFeatureAvailable() {
        return this.enabled;
    }

    @Override
    public IItemDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public void register() {
        if (this.enabled) {
            String name = this.extractor.get();
            this.item.func_111206_d("appliedenergistics2:" + name);
            this.item.func_77655_b("appliedenergistics2." + name);
            if (this.item instanceof ItemFacade) {
                this.item.func_77637_a((CreativeTabs)CreativeTabFacade.instance);
            } else {
                this.item.func_77637_a((CreativeTabs)CreativeTab.instance);
            }
            if (name.equals("ItemMaterial")) {
                name = "ItemMultiMaterial";
            } else if (name.equals("ItemPart")) {
                name = "ItemMultiPart";
            }
            GameRegistry.registerItem((Item)this.item, (String)("item." + name));
        }
    }
}

