/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.settings;

import appeng.core.AEConfig;

public enum TickRates {
    Interface(5, 120),
    ImportBus(5, 40),
    ExportBus(5, 60),
    AnnihilationPlane(2, 120),
    METunnel(5, 20),
    Inscriber(1, 1),
    IOPort(1, 5),
    VibrationChamber(10, 40),
    StorageBus(5, 60),
    ItemTunnel(5, 60),
    LightTunnel(5, 120),
    OpenComputersTunnel(1, 5),
    PressureTunnel(1, 120);

    private int min;
    private int max;

    private TickRates(int min, int max) {
        this.setMin(min);
        this.setMax(max);
    }

    public void Load(AEConfig config) {
        config.addCustomCategoryComment("TickRates", " Min / Max Tickrates for dynamic ticking, most of these components also use sleeping, to prevent constant ticking, adjust with care, non standard rates are not supported or tested.");
        this.setMin(config.get("TickRates", this.name() + ".min", this.getMin()).getInt(this.getMin()));
        this.setMax(config.get("TickRates", this.name() + ".max", this.getMax()).getInt(this.getMax()));
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }
}

