/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.worlddata;

import appeng.core.CommonHelper;
import appeng.core.worlddata.IOnWorldStartable;
import appeng.core.worlddata.IOnWorldStoppable;
import appeng.core.worlddata.IWorldPlayerData;
import appeng.core.worlddata.IWorldPlayerMapping;
import appeng.core.worlddata.PlayerMapping;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

final class PlayerData
implements IWorldPlayerData,
IOnWorldStartable,
IOnWorldStoppable {
    private static final String LAST_PLAYER_CATEGORY = "Counters";
    private static final String LAST_PLAYER_KEY = "lastPlayer";
    private static final int LAST_PLAYER_DEFAULT = 0;
    private final Configuration config;
    private final IWorldPlayerMapping playerMapping;
    private int lastPlayerID;

    public PlayerData(@Nonnull Configuration configFile) {
        Preconditions.checkNotNull((Object)configFile);
        this.config = configFile;
        ConfigCategory playerList = this.config.getCategory("players");
        this.playerMapping = new PlayerMapping(playerList);
    }

    @Override
    @Nullable
    public EntityPlayer getPlayerFromID(int playerID) {
        Optional<UUID> maybe = this.playerMapping.get(playerID);
        if (maybe.isPresent()) {
            UUID uuid = (UUID)maybe.get();
            for (EntityPlayer player : CommonHelper.proxy.getPlayers()) {
                if (!player.func_110124_au().equals(uuid)) continue;
                return player;
            }
        }
        return null;
    }

    @Override
    public int getPlayerID(@Nonnull GameProfile profile) {
        Preconditions.checkNotNull((Object)profile);
        Preconditions.checkNotNull((Object)this.config.getCategory("players"));
        Preconditions.checkState((boolean)profile.isComplete());
        ConfigCategory players = this.config.getCategory("players");
        String uuid = profile.getId().toString();
        Property maybePlayerID = players.get(uuid);
        if (maybePlayerID != null && maybePlayerID.isIntValue()) {
            return maybePlayerID.getInt();
        }
        int newPlayerID = this.nextPlayer();
        Property newPlayer = new Property(uuid, String.valueOf(newPlayerID), Property.Type.INTEGER);
        players.put(uuid, newPlayer);
        this.playerMapping.put(newPlayerID, profile.getId());
        this.config.save();
        return newPlayerID;
    }

    private int nextPlayer() {
        int r = this.lastPlayerID++;
        this.config.get(LAST_PLAYER_CATEGORY, LAST_PLAYER_KEY, this.lastPlayerID).set(this.lastPlayerID);
        return r;
    }

    @Override
    public void onWorldStart() {
        this.lastPlayerID = this.config.get(LAST_PLAYER_CATEGORY, LAST_PLAYER_KEY, 0).getInt(0);
        this.config.save();
    }

    @Override
    public void onWorldStop() {
        this.config.save();
        this.lastPlayerID = 0;
    }
}

