/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.storage;

import appeng.api.implementations.TransitionResult;
import appeng.api.implementations.items.ISpatialStorageCell;
import appeng.api.util.WorldCoord;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.core.worlddata.WorldData;
import appeng.items.AEBaseItem;
import appeng.spatial.StorageHelper;
import appeng.spatial.StorageWorldProvider;
import appeng.util.Platform;
import com.google.common.base.Optional;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ItemSpatialStorageCell
extends AEBaseItem
implements ISpatialStorageCell {
    private final int maxRegion;

    public ItemSpatialStorageCell(int spatialScale) {
        super((Optional<String>)Optional.of((Object)(spatialScale + "Cubed")));
        this.setFeature(EnumSet.of(AEFeature.SpatialIO));
        this.func_77625_d(1);
        this.maxRegion = spatialScale;
    }

    @Override
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        WorldCoord wc = this.getStoredSize(stack);
        if (wc.x > 0) {
            lines.add(GuiText.StoredSize.getLocal() + ": " + wc.x + " x " + wc.y + " x " + wc.z);
        }
    }

    @Override
    public boolean isSpatialStorage(ItemStack is) {
        return true;
    }

    @Override
    public int getMaxStoredDim(ItemStack is) {
        return this.maxRegion;
    }

    @Override
    public World getWorld(ItemStack is) {
        if (is.func_77942_o()) {
            NBTTagCompound c = is.func_77978_p();
            int dim = c.func_74762_e("StorageDim");
            WorldServer w = DimensionManager.getWorld((int)dim);
            if (w == null) {
                DimensionManager.initDimension((int)dim);
                w = DimensionManager.getWorld((int)dim);
            }
            if (w != null && w.field_73011_w instanceof StorageWorldProvider) {
                return w;
            }
        }
        return null;
    }

    @Override
    public WorldCoord getStoredSize(ItemStack is) {
        if (is.func_77942_o()) {
            NBTTagCompound c = is.func_77978_p();
            if (Platform.isServer()) {
                int dim = c.func_74762_e("StorageDim");
                return WorldData.instance().dimensionData().getStoredSize(dim);
            }
            return new WorldCoord(c.func_74762_e("sizeX"), c.func_74762_e("sizeY"), c.func_74762_e("sizeZ"));
        }
        return new WorldCoord(0, 0, 0);
    }

    @Override
    public WorldCoord getMin(ItemStack is) {
        NBTTagCompound info;
        World w = this.getWorld(is);
        if (w != null && (info = (NBTTagCompound)w.func_72912_H().getAdditionalProperty("storageCell")) != null) {
            return new WorldCoord(info.func_74762_e("minX"), info.func_74762_e("minY"), info.func_74762_e("minZ"));
        }
        return new WorldCoord(0, 0, 0);
    }

    @Override
    public WorldCoord getMax(ItemStack is) {
        NBTTagCompound info;
        World w = this.getWorld(is);
        if (w != null && (info = (NBTTagCompound)w.func_72912_H().getAdditionalProperty("storageCell")) != null) {
            return new WorldCoord(info.func_74762_e("maxX"), info.func_74762_e("maxY"), info.func_74762_e("maxZ"));
        }
        return new WorldCoord(0, 0, 0);
    }

    @Override
    public TransitionResult doSpatialTransition(ItemStack is, World w, WorldCoord min, WorldCoord max, boolean doTransition) {
        WorldCoord scale = this.getStoredSize(is);
        int targetX = max.x - min.x - 1;
        int targetY = max.y - min.y - 1;
        int targetZ = max.z - min.z - 1;
        int maxSize = this.getMaxStoredDim(is);
        World destination = this.getWorld(is);
        if ((scale.x == 0 && scale.y == 0 && scale.z == 0 || scale.x == targetX && scale.y == targetY && scale.z == targetZ) && targetX <= maxSize && targetY <= maxSize && targetZ <= maxSize) {
            if (destination == null) {
                destination = this.createNewWorld(is);
            }
            int floorBuffer = 64;
            StorageHelper.getInstance().swapRegions(w, destination, min.x + 1, min.y + 1, min.z + 1, 1, 65, 1, targetX - 1, targetY - 1, targetZ - 1);
            this.setStoredSize(is, targetX, targetY, targetZ);
            return new TransitionResult(true, 0.0);
        }
        return new TransitionResult(false, 0.0);
    }

    private World createNewWorld(ItemStack is) {
        NBTTagCompound c = Platform.openNbtData(is);
        int newDim = DimensionManager.getNextFreeDimId();
        c.func_74768_a("StorageDim", newDim);
        WorldData.instance().dimensionData().addStorageCell(newDim);
        DimensionManager.initDimension((int)newDim);
        return DimensionManager.getWorld((int)newDim);
    }

    private void setStoredSize(ItemStack is, int targetX, int targetY, int targetZ) {
        if (is.func_77942_o()) {
            NBTTagCompound c = is.func_77978_p();
            int dim = c.func_74762_e("StorageDim");
            c.func_74768_a("sizeX", targetX);
            c.func_74768_a("sizeY", targetY);
            c.func_74768_a("sizeZ", targetZ);
            WorldData.instance().dimensionData().setStoredSize(dim, targetX, targetY, targetZ);
        }
    }
}

