/*
 * Decompiled with CFR 0.152.
 */
package appeng.transformer.asm;

import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.transformer.annotations.Integration;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public final class ASMIntegration
implements IClassTransformer {
    public ASMIntegration() {
        for (IntegrationType type : IntegrationType.values()) {
            IntegrationRegistry.INSTANCE.add(type);
        }
    }

    @Nullable
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null || transformedName.startsWith("appeng.transformer")) {
            return basicClass;
        }
        if (transformedName.startsWith("appeng.")) {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            try {
                boolean reWrite = this.removeOptionals(classNode);
                if (reWrite) {
                    ClassWriter writer = new ClassWriter(1);
                    classNode.accept((ClassVisitor)writer);
                    return writer.toByteArray();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return basicClass;
    }

    private boolean removeOptionals(ClassNode classNode) {
        boolean changed = false;
        if (classNode.visibleAnnotations != null) {
            for (AnnotationNode an : classNode.visibleAnnotations) {
                if (this.hasAnnotation(an, Integration.Interface.class)) {
                    if (!this.stripInterface(classNode, Integration.Interface.class, an)) continue;
                    changed = true;
                    continue;
                }
                if (!this.hasAnnotation(an, Integration.InterfaceList.class)) continue;
                for (Object o : (Iterable)an.values.get(1)) {
                    if (!this.stripInterface(classNode, Integration.InterfaceList.class, (AnnotationNode)o)) continue;
                    changed = true;
                }
            }
        }
        Iterator<MethodNode> i = classNode.methods.iterator();
        while (i.hasNext()) {
            MethodNode mn = (MethodNode)i.next();
            if (mn.visibleAnnotations == null) continue;
            for (AnnotationNode an : mn.visibleAnnotations) {
                if (!this.hasAnnotation(an, Integration.Method.class) || !this.stripMethod(classNode, mn, i, Integration.Method.class, an)) continue;
                changed = true;
            }
        }
        if (changed) {
            this.log("Updated " + classNode.name);
        }
        return changed;
    }

    private boolean hasAnnotation(AnnotationNode ann, Class<?> annotation) {
        return ann.desc.equals(Type.getDescriptor(annotation));
    }

    private boolean stripInterface(ClassNode classNode, Class<?> class1, AnnotationNode an) {
        if (an.values.size() != 4) {
            throw new IllegalArgumentException("Unable to handle Interface annotation on " + classNode.name);
        }
        String iFace = null;
        if (an.values.get(0).equals("iface")) {
            iFace = (String)an.values.get(1);
        } else if (an.values.get(2).equals("iface")) {
            iFace = (String)an.values.get(3);
        }
        String iName = null;
        if (an.values.get(0).equals("iname")) {
            iName = ((String[])an.values.get(1))[1];
        } else if (an.values.get(2).equals("iname")) {
            iName = ((String[])an.values.get(3))[1];
        }
        if (iName != null && iFace != null) {
            IntegrationType type = IntegrationType.valueOf(iName);
            if (!IntegrationRegistry.INSTANCE.isEnabled(type)) {
                this.log("Removing Interface " + iFace + " from " + classNode.name + " because " + iName + " integration is disabled.");
                classNode.interfaces.remove(iFace.replace('.', '/'));
                return true;
            }
        } else {
            throw new IllegalStateException("Unable to handle Method annotation on " + classNode.name);
        }
        this.log("Allowing Interface " + iFace + " from " + classNode.name + " because " + iName + " integration is enabled.");
        return false;
    }

    private boolean stripMethod(ClassNode classNode, MethodNode mn, Iterator<MethodNode> i, Class class1, AnnotationNode an) {
        if (an.values.size() != 2) {
            throw new IllegalArgumentException("Unable to handle Method annotation on " + classNode.name);
        }
        String iName = null;
        if (an.values.get(0).equals("iname")) {
            iName = ((String[])an.values.get(1))[1];
        }
        if (iName != null) {
            IntegrationType type = IntegrationType.valueOf(iName);
            if (!IntegrationRegistry.INSTANCE.isEnabled(type)) {
                this.log("Removing Method " + mn.name + " from " + classNode.name + " because " + iName + " integration is disabled.");
                i.remove();
                return true;
            }
        } else {
            throw new IllegalStateException("Unable to handle Method annotation on " + classNode.name);
        }
        this.log("Allowing Method " + mn.name + " from " + classNode.name + " because " + iName + " integration is enabled.");
        return false;
    }

    private void log(String string) {
        FMLRelaunchLog.log((String)"AE2-CORE", (Level)Level.INFO, (String)string, (Object[])new Object[0]);
    }
}

