/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.util;

import net.minecraft.util.EnumFacing;

public enum AEPartLocation {
    DOWN(0, -1, 0),
    UP(0, 1, 0),
    NORTH(0, 0, -1),
    SOUTH(0, 0, 1),
    WEST(-1, 0, 0),
    EAST(1, 0, 0),
    INTERNAL(0, 0, 0);

    public final int xOffset;
    public final int yOffset;
    public final int zOffset;
    private static final EnumFacing[] facings;
    private static final int[] OPPOSITES;
    public static final AEPartLocation[] SIDE_LOCATIONS;

    private AEPartLocation(int x, int y, int z) {
        this.xOffset = x;
        this.yOffset = y;
        this.zOffset = z;
    }

    public static AEPartLocation fromOrdinal(int id) {
        if (id >= 0 && id < SIDE_LOCATIONS.length) {
            return SIDE_LOCATIONS[id];
        }
        return INTERNAL;
    }

    public static AEPartLocation fromFacing(EnumFacing side) {
        if (side == null) {
            return INTERNAL;
        }
        return AEPartLocation.values()[side.ordinal()];
    }

    public AEPartLocation getOpposite() {
        return AEPartLocation.fromOrdinal(OPPOSITES[this.ordinal()]);
    }

    public EnumFacing getFacing() {
        return facings[this.ordinal()];
    }

    static {
        facings = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST, null};
        OPPOSITES = new int[]{1, 0, 3, 2, 5, 4, 6};
        SIDE_LOCATIONS = new AEPartLocation[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    }
}

