/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.me.MachineSet;
import java.util.Iterator;
import java.util.Map;

public class GridNodeIterator
implements Iterator<IGridNode> {
    private final Iterator<MachineSet> outerIterator;
    private Iterator<IGridNode> innerIterator;

    public GridNodeIterator(Map<Class<? extends IGridHost>, MachineSet> machines) {
        this.outerIterator = machines.values().iterator();
        this.innerHasNext();
    }

    private boolean innerHasNext() {
        boolean hasNext = this.outerIterator.hasNext();
        if (hasNext) {
            MachineSet nextElem = this.outerIterator.next();
            this.innerIterator = nextElem.iterator();
        }
        return hasNext;
    }

    @Override
    public boolean hasNext() {
        do {
            if (!this.innerIterator.hasNext()) continue;
            return true;
        } while (this.innerHasNext());
        return false;
    }

    @Override
    public IGridNode next() {
        return this.innerIterator.next();
    }

    @Override
    public void remove() {
        this.innerIterator.remove();
    }
}

