/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import appeng.server.ISubCommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ChunkLogger
implements ISubCommand {
    private boolean enabled = false;

    @SubscribeEvent
    public void onChunkLoadEvent(ChunkEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            AELog.info("Chunk Loaded:   " + event.getChunk().field_76635_g + ", " + event.getChunk().field_76647_h, new Object[0]);
            this.displayStack();
        }
    }

    private void displayStack() {
        if (AEConfig.instance().isFeatureEnabled(AEFeature.CHUNK_LOGGER_TRACE)) {
            boolean output = false;
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                if (output) {
                    AELog.info("\t\t" + e.getClassName() + '.' + e.getMethodName() + " (" + e.getLineNumber() + ')', new Object[0]);
                    continue;
                }
                output = e.getClassName().contains("EventBus") && e.getMethodName().contains("post");
            }
        }
    }

    @SubscribeEvent
    public void onChunkUnloadEvent(ChunkEvent.Unload unload) {
        if (!unload.getWorld().field_72995_K) {
            AELog.info("Chunk Unloaded: " + unload.getChunk().field_76635_g + ", " + unload.getChunk().field_76647_h, new Object[0]);
            this.displayStack();
        }
    }

    @Override
    public String getHelp(MinecraftServer srv) {
        return "commands.ae2.ChunkLogger";
    }

    @Override
    public void call(MinecraftServer srv, String[] data, ICommandSender sender) {
        boolean bl = this.enabled = !this.enabled;
        if (this.enabled) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ae2.ChunkLoggerOn", new Object[0]));
        } else {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ae2.ChunkLoggerOff", new Object[0]));
        }
    }
}

