/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client;

import artifacts.client.model.layer.LayerDrinkingHat;
import artifacts.client.model.layer.LayerGloves;
import artifacts.client.model.layer.LayerNightVisionGoggles;
import artifacts.client.model.layer.LayerShirt;
import artifacts.client.model.layer.LayerSnorkel;
import artifacts.client.renderer.RenderHallowStar;
import artifacts.client.renderer.RenderMimic;
import artifacts.common.IProxy;
import artifacts.common.entity.EntityHallowStar;
import artifacts.common.entity.EntityMimic;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ClientProxy
implements IProxy {
    @Override
    public void preInit() {
        RenderingRegistry.registerEntityRenderingHandler(EntityMimic.class, (IRenderFactory)RenderMimic.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(EntityHallowStar.class, (IRenderFactory)RenderHallowStar.FACTORY);
    }

    @Override
    public void init() {
        ClientProxy.addRenderLayers();
    }

    @Override
    public void postInit() {
    }

    @Override
    public void registerItemRenderer(Item item, int meta, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("artifacts:" + name, "inventory"));
    }

    private static void addRenderLayers() {
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        RenderPlayer renderPlayer = (RenderPlayer)skinMap.get("default");
        renderPlayer.func_177094_a((LayerRenderer)new LayerGloves(false, renderPlayer));
        renderPlayer.func_177094_a((LayerRenderer)new LayerSnorkel(renderPlayer));
        renderPlayer.func_177094_a((LayerRenderer)new LayerDrinkingHat(renderPlayer));
        renderPlayer.func_177094_a((LayerRenderer)new LayerNightVisionGoggles(renderPlayer));
        renderPlayer.func_177094_a((LayerRenderer)new LayerShirt(renderPlayer, false));
        renderPlayer = (RenderPlayer)skinMap.get("slim");
        renderPlayer.func_177094_a((LayerRenderer)new LayerGloves(true, renderPlayer));
        renderPlayer.func_177094_a((LayerRenderer)new LayerSnorkel(renderPlayer));
        renderPlayer.func_177094_a((LayerRenderer)new LayerDrinkingHat(renderPlayer));
        renderPlayer.func_177094_a((LayerRenderer)new LayerNightVisionGoggles(renderPlayer));
        renderPlayer.func_177094_a((LayerRenderer)new LayerShirt(renderPlayer, true));
    }
}

