/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common;

import net.minecraftforge.common.config.Config;

@Config(modid="artifacts", name="Artifacts")
public class ModConfig {
    @Config.RangeDouble(min=0.0)
    @Config.Comment(value={"per-chunk chance an underground chest is attempted to generate, from y = 1 to y = 45", "setting this to 0 prevents underground chests from generating", "for values higher than 1, the amount of per-chunk attempts lies between floor(value) and ceil(value)"})
    public static double undergroundChestChance = 0.35;
    @Config.Comment(value={"list of dimensions underground chests can spawn in (separated by commas)"})
    public static String undergroundChestDimensions = "0";
    @Config.RangeDouble(min=0.0, max=1.0)
    @Config.Comment(value={"chance for a mimic to spawn instead of an underground chest", "setting this to 0 prevents underground mimics from generating"})
    public static double undergroundChestMimicRatio = 0.4;
    @Config.RangeDouble(min=0.0)
    @Config.Comment(value={"per-chunk chance an underwater shrine is attempted to generate, from y = 255 to y = 1, with at least 20 water blocks between the ocean surface and floor", "setting this to 0 prevents underwater shrines from generating", "for values higher than 1, the amount of per-chunk attempts lies between floor(value) and ceil(value)"})
    public static double underwaterShrineChance = 0.001;
    @Config.Comment(value={"list of dimensions underwater shrines can spawn in (separated by commas)"})
    public static String underwaterShrineDimensions = "0";
    @Config.Comment(value={"whether animals can drop everlasting food"})
    public static boolean enableEverlastingFood = true;
    @Config.RangeInt(min=0)
    @Config.Comment(value={"Minimum amount of falling stars that spawn when struck while wearing a star cloak"})
    public static int starCloakStarsMin = 3;
    @Config.RangeInt(min=0)
    @Config.Comment(value={"Maximum amount of falling stars that spawn when struck while wearing a star cloak"})
    public static int starCloakStarsMax = 8;
    @Config.RangeInt(min=0)
    @Config.Comment(value={"Hallow star damage when striking an entity"})
    public static int starCloakDamage = 4;
    @Config.RangeInt(min=1)
    @Config.Comment(value={"Attack damage boost for power glove, mechanical glove & fire gauntlet"})
    public static int attackDamageBoost = 3;
}

