/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.common.ModConfig;
import artifacts.common.item.BaubleBase;
import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.artemis.artemislib.util.attributes.ArtemisLibAttributes;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;

public class AttributeModifierBauble
extends BaubleBase {
    private final Set<ExtendedAttributeModifier> attributeModifiers;

    public AttributeModifierBauble(String name, BaubleType type, ExtendedAttributeModifier ... attributeModifiers) {
        super(name, type);
        this.attributeModifiers = new HashSet<ExtendedAttributeModifier>(Arrays.asList(attributeModifiers));
    }

    @Override
    public void onEquipped(ItemStack stack, EntityLivingBase player) {
        super.onEquipped(stack, player);
        if (player instanceof EntityPlayer) {
            this.applyModifiers(null, (EntityPlayer)player);
        }
    }

    @Override
    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        super.onUnequipped(stack, player);
        if (player instanceof EntityPlayer) {
            this.applyModifiers(stack, (EntityPlayer)player);
        }
    }

    private void applyModifiers(@Nullable ItemStack excludedStack, EntityPlayer player) {
        IBaublesItemHandler baublesHandler = BaublesApi.getBaublesHandler((EntityPlayer)player);
        HashSet<ExtendedAttributeModifier> modifiers = new HashSet<ExtendedAttributeModifier>();
        for (int slot : BaubleType.TRINKET.getValidSlots()) {
            ItemStack stack = baublesHandler.getStackInSlot(slot);
            if (!(stack.func_77973_b() instanceof AttributeModifierBauble) || stack == excludedStack) continue;
            modifiers.addAll(((AttributeModifierBauble)stack.func_77973_b()).attributeModifiers);
        }
        modifiers.retainAll(this.attributeModifiers);
        Object object = this.attributeModifiers.iterator();
        while (object.hasNext()) {
            ExtendedAttributeModifier modifier = (ExtendedAttributeModifier)((Object)object.next());
            for (IAttribute attribute : modifier.affectedAttributes) {
                IAttributeInstance instance = player.func_110140_aT().func_111151_a(attribute);
                if (instance.func_111127_a(modifier.func_111167_a()) == null) continue;
                instance.func_188479_b(modifier.func_111167_a());
            }
        }
        for (ExtendedAttributeModifier modifier : modifiers) {
            for (IAttribute attribute : modifier.affectedAttributes) {
                player.func_110140_aT().func_111151_a(attribute).func_111121_a((AttributeModifier)modifier);
            }
        }
    }

    public static class ExtendedAttributeModifier
    extends AttributeModifier {
        public static ExtendedAttributeModifier ATTACK_DAMAGE = new ExtendedAttributeModifier(UUID.fromString("15fab7b9-5916-460b-a8e8-8434849a0662"), "attack damage boost", ModConfig.attackDamageBoost, 0, SharedMonsterAttributes.field_111264_e);
        public static ExtendedAttributeModifier ATTACK_SPEED = new ExtendedAttributeModifier(UUID.fromString("7a3367b2-0a38-491d-b5c7-338d5d0c1dd4"), "attack speed boost", 1.0, 2, SharedMonsterAttributes.field_188790_f);
        public static ExtendedAttributeModifier SHRINKING = new ExtendedAttributeModifier(UUID.fromString("d4203885-1dbe-42ac-8891-30efd5b2ee7e"), "shrinking", 0.0, 0, new IAttribute[0]);
        public final IAttribute[] affectedAttributes;

        @Optional.Method(modid="artemislib")
        public static void initShrinkingModifier() {
            SHRINKING = new ExtendedAttributeModifier(UUID.fromString("d4203885-1dbe-42ac-8891-30efd5b2ee7e"), "shrinking", -0.5, 2, ArtemisLibAttributes.ENTITY_HEIGHT, ArtemisLibAttributes.ENTITY_WIDTH);
        }

        public ExtendedAttributeModifier(UUID id, String nameIn, double amountIn, int operationIn, IAttribute ... affectedAttributes) {
            super(id, nameIn, amountIn, operationIn);
            this.affectedAttributes = affectedAttributes;
            this.func_111168_a(true);
        }
    }
}

