/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.Artifacts;
import artifacts.common.ModConfig;
import artifacts.common.loot.functions.GenerateEverlastingFish;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.food.IEdible;
import squeek.applecore.api.food.ItemFoodProxy;

@Mod.EventBusSubscriber
@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Optional.Interface(iface="squeek.applecore.api.food.IEdible", modid="applecore")
public class ItemEverlastingFood
extends Item
implements IEdible {
    public final String name;
    private final int amount;
    private final float saturation;
    private PotionEffect potionEffect;
    private float potionProbability;

    public ItemEverlastingFood(String name, int amount, float saturation) {
        this.setRegistryName(name);
        this.func_77655_b("artifacts." + name);
        this.func_77637_a(CreativeTabs.field_78039_h);
        this.func_77625_d(1);
        this.name = name;
        this.amount = amount;
        this.saturation = saturation;
    }

    @Optional.Method(modid="applecore")
    public FoodValues getFoodValues(ItemStack itemStack) {
        return new FoodValues(this.amount, this.saturation);
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.EAT;
    }

    protected void onFoodEaten(ItemStack stack, World worldIn, EntityPlayer player) {
        if (!worldIn.field_72995_K && this.potionEffect != null && worldIn.field_73012_v.nextFloat() < this.potionProbability) {
            player.func_70690_d(new PotionEffect(this.potionEffect));
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public void registerModel() {
        Artifacts.proxy.registerItemRenderer(this, 0, this.name);
    }

    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.RARE;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (Loader.isModLoaded((String)"applecore")) {
                this.onEatenCompatibility(stack, player);
            } else {
                player.func_71024_bL().func_75122_a(this.amount, this.saturation);
            }
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            this.onFoodEaten(stack, world, player);
            player.func_71029_a(StatList.func_188057_b((Item)this));
        }
        return stack;
    }

    @Optional.Method(modid="applecore")
    public void onEatenCompatibility(ItemStack stack, EntityPlayer player) {
        new ItemFoodProxy((IEdible)this).onEaten(stack, player);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (playerIn.func_71043_e(false)) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    public ItemEverlastingFood setPotionEffect(PotionEffect effect, float probability) {
        this.potionEffect = effect;
        this.potionProbability = probability;
        return this;
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation location;
        if (!ModConfig.enableEverlastingFood) {
            return;
        }
        if (event.getName().toString().equals("minecraft:gameplay/fishing/fish")) {
            LootFunction[] functions = new LootFunction[]{new GenerateEverlastingFish(new LootCondition[]{new RandomChance(0.05f)})};
            event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem(Items.field_151115_aP, 1, 0, functions, new LootCondition[0], "everlasting_fish"));
        }
        switch (event.getName().toString()) {
            case "minecraft:entities/cow": 
            case "minecraft:entities/mushroom_cow": {
                location = new ResourceLocation("artifacts", "everlasting_food/beef");
                break;
            }
            case "minecraft:entities/pig": {
                location = new ResourceLocation("artifacts", "everlasting_food/porkchop");
                break;
            }
            case "minecraft:entities/chicken": {
                location = new ResourceLocation("artifacts", "everlasting_food/chicken");
                break;
            }
            case "minecraft:entities/sheep": {
                location = new ResourceLocation("artifacts", "everlasting_food/mutton");
                break;
            }
            case "minecraft:entities/rabbit": {
                location = new ResourceLocation("artifacts", "everlasting_food/rabbit");
                break;
            }
            case "minecraft:entities/spider": 
            case "minecraft:entities/cave_spider": {
                location = new ResourceLocation("artifacts", "everlasting_food/spider_eye");
                break;
            }
            case "minecraft:entities/zombie": 
            case "minecraft:entities/husk": 
            case "minecraft:entities/zombie_villager": 
            case "minecraft:entities/zombie_pigman": 
            case "minecraft:entities/zombie_horse": {
                location = new ResourceLocation("artifacts", "everlasting_food/rotten_flesh");
                break;
            }
            default: {
                return;
            }
        }
        LootEntryTable entry = new LootEntryTable(location, 1, 0, new LootCondition[0], "entry#0");
        event.getTable().addPool(new LootPool(new LootEntry[]{entry}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f), "everlasting_food"));
    }
}

