/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.worldgen;

import artifacts.common.ModConfig;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenOceanShrine
implements IWorldGenerator {
    private static final ResourceLocation STRUCTURE = new ResourceLocation("artifacts", "ocean_shrine");
    private final List<Integer> whitelistedDimensions;

    public WorldGenOceanShrine(List<Integer> whitelistedDimensions) {
        this.whitelistedDimensions = whitelistedDimensions;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.func_175624_G() == WorldType.field_77138_c || !this.whitelistedDimensions.contains(world.field_73011_w.getDimension())) {
            return;
        }
        for (double chestChance = ModConfig.underwaterShrineChance; chestChance > 0.0; chestChance -= 1.0) {
            if (!(random.nextDouble() <= chestChance)) continue;
            BlockPos pos = this.getUnderwaterBlock(world, new BlockPos(chunkX * 16 + 8 + random.nextInt(16), 255, chunkZ * 16 + 8 + random.nextInt(16)));
            if (pos == null) {
                return;
            }
            PlacementSettings settings = new PlacementSettings().func_186220_a(Rotation.values()[random.nextInt(4)]);
            Template template = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), STRUCTURE);
            template.func_186253_b(world, pos.func_177982_a(-3, -1, -3), settings);
        }
    }

    @Nullable
    private BlockPos getUnderwaterBlock(World world, BlockPos pos) {
        int depth = 0;
        while (pos.func_177956_o() >= 1) {
            if (world.func_180495_p(pos).func_185904_a().func_76224_d()) {
                if (world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) && ++depth >= 20) {
                    return pos;
                }
            } else if (depth > 0 || !world.func_175623_d(pos)) {
                return null;
            }
            pos = pos.func_177977_b();
        }
        return null;
    }
}

