/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.worldgen;

import artifacts.common.ModConfig;
import artifacts.common.entity.EntityMimic;
import artifacts.common.init.ModLootTables;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

@ParametersAreNonnullByDefault
public class WorldGenUndergroundChest
implements IWorldGenerator {
    private final List<Integer> whitelistedDimensions;

    public WorldGenUndergroundChest(List<Integer> whitelistedDimensions) {
        this.whitelistedDimensions = whitelistedDimensions;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.func_175624_G() == WorldType.field_77138_c || !this.whitelistedDimensions.contains(world.field_73011_w.getDimension())) {
            return;
        }
        for (double chestChance = ModConfig.undergroundChestChance; chestChance > 0.0; chestChance -= 1.0) {
            if (!(random.nextDouble() <= chestChance)) continue;
            this.generateChest(world, random, chunkX, chunkZ);
        }
    }

    private void generateChest(World world, Random random, int chunkX, int chunkZ) {
        BlockPos pos = this.getFirstTopSolidBlock(world, new BlockPos(chunkX * 16 + 8 + random.nextInt(16), 1, chunkZ * 16 + 8 + random.nextInt(16)));
        if (pos != null) {
            if (random.nextDouble() < ModConfig.undergroundChestMimicRatio) {
                EntityMimic mimic = new EntityMimic(world);
                mimic.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, random.nextInt(4) * 90, 0.0f);
                mimic.setDormant();
                mimic.func_110163_bv();
                world.func_72838_d((Entity)mimic);
            } else {
                world.func_180501_a(pos, Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.field_176754_o[random.nextInt(4)]), 2);
                TileEntity tileentity = world.func_175625_s(pos);
                if (tileentity instanceof TileEntityChest) {
                    ((TileEntityChest)tileentity).func_189404_a(ModLootTables.CHEST_UNDERGROUND, random.nextLong());
                }
            }
        }
    }

    @Nullable
    private BlockPos getFirstTopSolidBlock(World world, BlockPos pos) {
        while (pos.func_177956_o() <= 45) {
            IBlockState downState = world.func_180495_p(pos.func_177977_b());
            if (downState.isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) && world.func_175623_d(pos)) {
                return pos;
            }
            pos = pos.func_177984_a();
        }
        return null;
    }
}

