/*
 * Decompiled with CFR 0.152.
 */
package artifacts;

import artifacts.client.render.MimicRenderer;
import artifacts.common.config.Config;
import artifacts.common.init.Entities;
import artifacts.common.init.Features;
import artifacts.common.init.Items;
import artifacts.common.init.LootModifiers;
import artifacts.common.init.SoundEvents;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.registries.IForgeRegistry;
import top.theillusivec4.curios.api.imc.CurioIMCMessage;

@Mod(value="artifacts")
public class Artifacts {
    public static final String MODID = "artifacts";
    public static final ItemGroup CREATIVE_TAB = new ItemGroup("artifacts"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)Items.PLASTIC_DRINKING_HAT);
        }
    };

    public Artifacts() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON_SPEC);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void commonSetup(FMLCommonSetupEvent event) {
            Features.addFeatures();
        }

        @SubscribeEvent
        public static void setupClient(FMLClientSetupEvent event) {
            RenderingRegistry.registerEntityRenderingHandler(Entities.MIMIC, MimicRenderer::new);
        }

        @SubscribeEvent
        public static void enqueueIMC(InterModEnqueueEvent event) {
            String[] slots;
            for (String slot : slots = new String[]{"head", "necklace", "hands", "belt", "feet"}) {
                InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage(slot));
            }
            InterModComms.sendTo((String)"curios", (String)"register_icon", () -> new Tuple((Object)"feet", (Object)PlayerContainer.field_226619_g_));
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            Items.register((IForgeRegistry<Item>)event.getRegistry());
        }

        @SubscribeEvent
        public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
            Entities.register(event.getRegistry());
        }

        @SubscribeEvent
        public static void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
            SoundEvents.register((IForgeRegistry<SoundEvent>)event.getRegistry());
        }

        @SubscribeEvent
        public static void registerLootModifiers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
            LootModifiers.register(event.getRegistry());
        }

        @SubscribeEvent
        public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
            Features.registerFeatures(event.getRegistry());
        }
    }
}

