/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    final ForgeConfigSpec.DoubleValue campsiteChance;
    final ForgeConfigSpec.DoubleValue campsiteMimicChance;
    final ForgeConfigSpec.DoubleValue campsiteOreChance;
    final ForgeConfigSpec.IntValue campsiteMinY;
    final ForgeConfigSpec.IntValue campsiteMaxY;

    CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("campsite");
        this.campsiteChance = builder.comment("Per-chunk chance a campsite is attempted to be generated. Not every attempt succeeds, this also depends on the density and shape of caves").translation("artifacts.config.campsite_chance").defineInRange("campsite_chance", 0.2, 0.0, 1.0);
        this.campsiteMinY = builder.comment("The minimum y-level at which a campsite can generate").translation("artifacts.config.campsite_min_y").defineInRange("campsite_min_y", 0, 0, 255);
        this.campsiteMaxY = builder.comment("The maximum y-level at which a campsite can generate").translation("artifacts.config.campsite_max_y").defineInRange("campsite_max_y", 45, 0, 255);
        this.campsiteMimicChance = builder.comment("Chance for a container of a campsite to be replaced by a mimic").translation("artifacts.config.campsite_mimic_chance").defineInRange("campsite_mimic_chance", 0.2, 0.0, 1.0);
        this.campsiteOreChance = builder.comment("Chance for an ore vein to generate underneath a campsite").translation("artifacts.config.campsite_ore_chance").defineInRange("campsite_ore_chance", 0.25, 0.0, 1.0);
        builder.pop();
    }
}

