/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.entity;

import artifacts.common.init.LootTables;
import artifacts.common.init.SoundEvents;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class MimicEntity
extends MobEntity
implements IMob {
    public int ticksInAir;
    public boolean isDormant;

    public MimicEntity(EntityType<? extends MimicEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new MimicMovementController(this);
        this.field_70728_aV = 10;
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        if (this.func_70605_aq() instanceof MimicMovementController) {
            ((MimicMovementController)this.field_70765_h).setDirection(this.field_70146_Z.nextInt(4) * 90, false);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public boolean func_213397_c(double distance) {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new FloatGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FaceRandomGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new HopGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 1, true, false, entity -> !this.isDormant || (double)this.func_70032_d((Entity)entity) < this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e() / 2.5));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("ticksInAir", this.ticksInAir);
        compound.func_74757_a("isDormant", this.isDormant);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.ticksInAir = compound.func_74762_e("ticksInAir");
        this.isDormant = compound.func_74767_n("isDormant");
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70090_H()) {
            this.ticksInAir = 0;
            if (this.isDormant) {
                this.isDormant = false;
            }
        } else if (!this.field_70122_E) {
            ++this.ticksInAir;
        } else if (this.ticksInAir > 0) {
            this.func_184185_a(this.getLandingSound(), this.func_70599_aP(), this.func_70647_i());
            this.ticksInAir = 0;
        }
    }

    public void func_70100_b_(PlayerEntity player) {
        super.func_70100_b_(player);
        if (player.func_130014_f_().func_175659_aa() != Difficulty.PEACEFUL && this.func_70685_l((Entity)player) && this.func_70068_e((Entity)player) < 1.0 && player.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e())) {
            this.func_174815_a((LivingEntity)this, (Entity)player);
        }
    }

    public void func_70624_b(LivingEntity entity) {
        this.isDormant = false;
        super.func_70624_b(entity);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof PlayerEntity) {
            this.func_70624_b((LivingEntity)source.func_76346_g());
        }
        if (this.ticksInAir <= 0 && !source.func_180136_u() && source.func_76346_g() != null) {
            this.func_184185_a(SoundEvents.MIMIC_HURT, this.func_70599_aP(), this.func_70647_i());
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.MIMIC_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.MIMIC_DEATH;
    }

    protected SoundEvent getJumpingSound() {
        return SoundEvents.MIMIC_OPEN;
    }

    protected SoundEvent getLandingSound() {
        return SoundEvents.MIMIC_CLOSE;
    }

    protected ResourceLocation func_184647_J() {
        return LootTables.MIMIC;
    }

    public void setDormant() {
        this.isDormant = true;
    }

    protected static class MimicMovementController
    extends MovementController {
        private final MimicEntity mimic;
        private float rotationDegrees;
        private int jumpDelay;

        public MimicMovementController(MimicEntity mimic) {
            super((MobEntity)mimic);
            this.mimic = mimic;
            this.rotationDegrees = 180.0f * mimic.field_70177_z / (float)Math.PI;
            this.jumpDelay = mimic.field_70146_Z.nextInt(320) + 640;
        }

        public void setDirection(float rotation, boolean isAggressive) {
            this.rotationDegrees = rotation;
            if (isAggressive && this.jumpDelay > 20) {
                this.jumpDelay = this.mimic.field_70146_Z.nextInt(10) + 10;
            }
        }

        public void setSpeed(double speed) {
            this.field_75645_e = speed;
            this.field_188491_h = MovementController.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.mimic.field_70761_aq = this.mimic.field_70177_z = this.func_75639_a(this.mimic.field_70177_z, this.rotationDegrees, 90.0f);
            this.mimic.field_70759_as = this.mimic.field_70177_z;
            if (this.field_188491_h != MovementController.Action.MOVE_TO) {
                this.mimic.func_191989_p(0.0f);
            } else {
                this.field_188491_h = MovementController.Action.WAIT;
                if (this.mimic.field_70122_E) {
                    this.mimic.func_70659_e((float)(this.field_75645_e * this.mimic.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.jumpDelay-- > 0) {
                        this.mimic.field_191988_bg = 0.0f;
                        this.mimic.field_70702_br = 0.0f;
                        this.mimic.func_70659_e(0.0f);
                    } else {
                        this.jumpDelay = this.mimic.field_70146_Z.nextInt(320) + 640;
                        this.mimic.field_70767_i.func_75660_a();
                        this.mimic.func_184185_a(this.mimic.getJumpingSound(), this.mimic.func_70599_aP(), this.mimic.func_70647_i());
                    }
                } else {
                    this.mimic.func_70659_e((float)(this.field_75645_e * this.mimic.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }
    }

    protected static class HopGoal
    extends Goal {
        private final MimicEntity mimic;

        public HopGoal(MimicEntity mimic) {
            this.mimic = mimic;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !this.mimic.isDormant && !this.mimic.func_184218_aH();
        }

        public void func_75246_d() {
            if (this.mimic.func_70605_aq() instanceof MimicMovementController) {
                ((MimicMovementController)this.mimic.func_70605_aq()).setSpeed(1.0);
            }
        }
    }

    protected static class FloatGoal
    extends Goal {
        private final MimicEntity mimic;

        public FloatGoal(MimicEntity mimic) {
            this.mimic = mimic;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            mimic.func_70661_as().func_212239_d(true);
        }

        public boolean func_75250_a() {
            return this.mimic.func_70090_H() || this.mimic.func_180799_ab();
        }

        public void func_75246_d() {
            if (this.mimic.func_70681_au().nextFloat() < 0.8f) {
                this.mimic.field_70767_i.func_75660_a();
            }
            if (this.mimic.func_70605_aq() instanceof MimicMovementController) {
                ((MimicMovementController)this.mimic.func_70605_aq()).setSpeed(1.2);
            }
        }
    }

    protected static class FaceRandomGoal
    extends Goal {
        private final MimicEntity mimic;
        private int chosenDegrees;
        private int nextRandomizeTime;

        public FaceRandomGoal(MimicEntity mimic) {
            this.mimic = mimic;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return this.mimic.func_70638_az() == null && (this.mimic.field_70122_E || this.mimic.func_70090_H() || this.mimic.func_180799_ab() || this.mimic.func_70644_a(Effects.field_188424_y));
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 480 + this.mimic.func_70681_au().nextInt(320);
                this.chosenDegrees = this.mimic.isDormant ? Math.round(this.mimic.field_70177_z / 90.0f) * 90 : this.mimic.func_70681_au().nextInt(4) * 90;
            }
            if (this.mimic.func_70605_aq() instanceof MimicMovementController) {
                ((MimicMovementController)this.mimic.func_70605_aq()).setDirection(this.chosenDegrees, false);
            }
        }
    }

    protected static class AttackGoal
    extends Goal {
        private final MimicEntity mimic;
        private int timeRemaining;

        public AttackGoal(MimicEntity mimic) {
            this.mimic = mimic;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingEntity = this.mimic.func_70638_az();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.func_70089_S()) {
                return false;
            }
            return !(livingEntity instanceof PlayerEntity) || !((PlayerEntity)livingEntity).field_71075_bZ.field_75102_a;
        }

        public void func_75249_e() {
            this.timeRemaining = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            LivingEntity livingEntity = this.mimic.func_70638_az();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.func_70089_S()) {
                return false;
            }
            if (livingEntity instanceof PlayerEntity && ((PlayerEntity)livingEntity).field_71075_bZ.field_75102_a) {
                return false;
            }
            return --this.timeRemaining > 0;
        }

        public void func_75246_d() {
            super.func_75246_d();
            if (this.mimic.func_70638_az() != null && this.mimic.func_70605_aq() instanceof MimicMovementController) {
                this.mimic.func_70625_a((Entity)this.mimic.func_70638_az(), 10.0f, 10.0f);
                ((MimicMovementController)this.mimic.func_70605_aq()).setDirection(this.mimic.field_70177_z, true);
            }
        }
    }
}

