/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.init;

import java.util.Arrays;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.TableLootEntry;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class LootTables {
    public static final ResourceLocation MIMIC = new ResourceLocation("artifacts", "entities/mimic");
    public static final ResourceLocation CAMPSITE_CHEST = new ResourceLocation("artifacts", "chests/campsite_chest");

    @Mod.EventBusSubscriber(modid="artifacts")
    public static class LootTableEvents {
        public static final List<String> LOOT_TABLE_LOCATIONS = Arrays.asList("chests/village/village_armorer", "chests/village/village_butcher", "chests/village/village_tannery", "chests/village/village_temple", "chests/village/village_toolsmith", "chests/village/village_weaponsmith", "chests/abandoned_mineshaft", "chests/buried_treasure", "chests/desert_pyramid", "chests/jungle_temple", "chests/underwater_ruin_big", "chests/woodland_mansion", "entities/cow");

        @SubscribeEvent
        public static void onLootTableLoad(LootTableLoadEvent event) {
            String location;
            String prefix = "minecraft:";
            String name = event.getName().toString();
            if (name.startsWith(prefix) && LOOT_TABLE_LOCATIONS.contains(location = name.substring(name.indexOf(prefix) + prefix.length()))) {
                event.getTable().addPool(LootTableEvents.getInjectPool(location));
            }
        }

        public static LootPool getInjectPool(String entryName) {
            return LootPool.func_216096_a().func_216045_a(LootTableEvents.getInjectEntry(entryName)).name("artifacts_inject").func_216044_b();
        }

        private static LootEntry.Builder<?> getInjectEntry(String name) {
            ResourceLocation table = new ResourceLocation("artifacts", "inject/" + name);
            return TableLootEntry.func_216171_a((ResourceLocation)table).func_216086_a(1);
        }
    }
}

