/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.CuriosCapability;
import top.theillusivec4.curios.api.capability.ICurio;

abstract class Curio
implements ICurio {
    private final Item curioItem;
    private final SoundEvent equipSound = this.getEquipSound();

    public Curio(Item item) {
        this.curioItem = item;
    }

    public static ICapabilityProvider createProvider(ICurio curio) {
        return new Provider(curio);
    }

    protected SoundEvent getEquipSound() {
        return SoundEvents.field_187728_s;
    }

    public void playEquipSound(LivingEntity entity) {
        entity.field_70170_p.func_184133_a(null, entity.func_180425_c(), this.equipSound, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    public boolean canRightClickEquip() {
        return true;
    }

    public boolean canEquip(String identifier, LivingEntity entity) {
        return !CuriosAPI.getCurioEquipped((Item)this.curioItem, (LivingEntity)entity).isPresent();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasRender(String identifier, LivingEntity livingEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(String identifier, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        BipedModel<LivingEntity> model = this.getModel();
        RenderHelper.setBodyRotationAngles(entity, limbSwing, limbSwingAmount, ageInTicks, partialTicks, netHeadYaw, headPitch, model);
        IVertexBuilder vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)model.func_228282_a_(this.getTexture()), (boolean)false, (boolean)false);
        model.func_225598_a_(matrixStack, vertexBuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract BipedModel<LivingEntity> getModel();

    @OnlyIn(value=Dist.CLIENT)
    protected abstract ResourceLocation getTexture();

    @OnlyIn(value=Dist.CLIENT)
    public static final class RenderHelper {
        private RenderHelper() {
        }

        public static void setBodyRotationAngles(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float partialTicks, float netHeadYaw, float headPitch, BipedModel<LivingEntity> model) {
            ICurio.RenderHelper.followBodyRotations((LivingEntity)entity, (BipedModel[])new BipedModel[]{model});
            model.func_225597_a_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            model.func_212843_a_(entity, limbSwing, limbSwingAmount, partialTicks);
        }
    }

    protected static class Provider
    implements ICapabilityProvider {
        private final LazyOptional<ICurio> capability = LazyOptional.of(() -> curio);

        Provider(ICurio curio) {
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return CuriosCapability.ITEM.orEmpty(cap, this.capability);
        }
    }
}

