/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.ClawsModel;
import artifacts.common.init.Items;
import artifacts.common.item.ArtifactItem;
import artifacts.common.item.Curio;
import artifacts.common.item.GloveCurio;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosAPI;

public class DiggingClawsItem
extends ArtifactItem {
    private static final ResourceLocation TEXTURE_DEFAULT = new ResourceLocation("artifacts", "textures/entity/curio/digging_claws_default.png");
    private static final ResourceLocation TEXTURE_SLIM = new ResourceLocation("artifacts", "textures/entity/curio/digging_claws_default.png");

    public DiggingClawsItem() {
        super(new Item.Properties(), "digging_claws");
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return Curio.createProvider(new GloveCurio(this){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation getTexture() {
                return TEXTURE_DEFAULT;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation getSlimTexture() {
                return TEXTURE_SLIM;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ClawsModel getSlimModel() {
                if (this.model_slim == null) {
                    this.model_slim = new ClawsModel(true);
                }
                return (ClawsModel)((Object)this.model_slim);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ClawsModel getModel() {
                if (this.model_default == null) {
                    this.model_default = new ClawsModel(false);
                }
                return (ClawsModel)((Object)this.model_default);
            }
        });
    }

    @Mod.EventBusSubscriber(modid="artifacts")
    public static class Events {
        @SubscribeEvent
        public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
            if (CuriosAPI.getCurioEquipped((Item)Items.DIGGING_CLAWS, (LivingEntity)event.getEntityLiving()).isPresent()) {
                event.setNewSpeed(event.getNewSpeed() + 3.0f);
            }
        }

        @SubscribeEvent
        public static void onHarvestCheck(PlayerEvent.HarvestCheck event) {
            if (!event.canHarvest() && CuriosAPI.getCurioEquipped((Item)Items.DIGGING_CLAWS, (LivingEntity)event.getEntityLiving()).isPresent()) {
                event.setCanHarvest(event.canHarvest() || event.getTargetBlock().getHarvestLevel() <= 2);
            }
        }
    }
}

