/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.DrinkingHatModel;
import artifacts.common.item.ArtifactItem;
import artifacts.common.item.Curio;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosAPI;

public class DrinkingHatItem
extends ArtifactItem {
    private static final ResourceLocation TEXTURE_DEFAULT = new ResourceLocation("artifacts", "textures/entity/curio/plastic_drinking_hat.png");
    private static final ResourceLocation TEXTURE_NOVELTY = new ResourceLocation("artifacts", "textures/entity/curio/novelty_drinking_hat.png");
    private final boolean isNoveltyHat;

    public DrinkingHatItem(String name, boolean isNoveltyHat) {
        super(new Item.Properties(), name);
        this.isNoveltyHat = isNoveltyHat;
    }

    @Override
    public Rarity func_77613_e(ItemStack stack) {
        return this.isNoveltyHat ? Rarity.EPIC : Rarity.RARE;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return Curio.createProvider(new Curio(this){
            private Object model;

            @Override
            protected SoundEvent getEquipSound() {
                return SoundEvents.field_187615_H;
            }

            @OnlyIn(value=Dist.CLIENT)
            protected DrinkingHatModel getModel() {
                if (this.model == null) {
                    this.model = new DrinkingHatModel();
                }
                return (DrinkingHatModel)((Object)this.model);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation getTexture() {
                return DrinkingHatItem.this.isNoveltyHat ? TEXTURE_NOVELTY : TEXTURE_DEFAULT;
            }
        });
    }

    @Mod.EventBusSubscriber(modid="artifacts")
    public static class Events {
        @SubscribeEvent
        public static void onItemUseStart(LivingEntityUseItemEvent.Start event) {
            if (CuriosAPI.getCurioEquipped(stack -> stack.func_77973_b() instanceof DrinkingHatItem, (LivingEntity)event.getEntityLiving()).isPresent() && event.getItem().func_77975_n() == UseAction.DRINK) {
                event.setDuration(event.getDuration() / 4);
            }
        }
    }
}

