/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.GloveModel;
import artifacts.common.item.Curio;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class GloveCurio
extends Curio {
    protected Object model_default;
    protected Object model_slim;

    public GloveCurio(Item item) {
        super(item);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static boolean hasSmallArms(Entity entity) {
        return entity instanceof AbstractClientPlayerEntity && ((AbstractClientPlayerEntity)entity).func_175154_l().equals("slim");
    }

    @OnlyIn(value=Dist.CLIENT)
    protected ResourceLocation getTexture(boolean smallArms) {
        return smallArms ? this.getSlimTexture() : this.getTexture();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract ResourceLocation getSlimTexture();

    @OnlyIn(value=Dist.CLIENT)
    protected GloveModel getModel(boolean smallArms) {
        return smallArms ? this.getSlimModel() : this.getModel();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected GloveModel getSlimModel() {
        if (this.model_slim == null) {
            this.model_slim = new GloveModel(true);
        }
        return (GloveModel)((Object)this.model_slim);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected GloveModel getModel() {
        if (this.model_default == null) {
            this.model_default = new GloveModel(false);
        }
        return (GloveModel)((Object)this.model_default);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(String identifier, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean smallArms = GloveCurio.hasSmallArms((Entity)entity);
        GloveModel model = this.getModel(smallArms);
        Curio.RenderHelper.setBodyRotationAngles(entity, limbSwing, limbSwingAmount, ageInTicks, partialTicks, netHeadYaw, headPitch, (BipedModel<LivingEntity>)model);
        IVertexBuilder vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)model.func_228282_a_(this.getTexture(smallArms)), (boolean)false, (boolean)false);
        model.renderRightArm(matrixStack, vertexBuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

