/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.ScarfModel;
import artifacts.common.item.ArtifactItem;
import artifacts.common.item.Curio;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import top.theillusivec4.curios.api.CuriosAPI;

public class LuckyScarfItem
extends ArtifactItem {
    private static final ResourceLocation TEXTURE = new ResourceLocation("artifacts", "textures/entity/curio/lucky_scarf.png");

    public LuckyScarfItem() {
        super(new Item.Properties(), "lucky_scarf");
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return Curio.createProvider(new Curio(this){
            private Object model;

            @OnlyIn(value=Dist.CLIENT)
            protected ScarfModel getModel() {
                if (this.model == null) {
                    this.model = new ScarfModel();
                }
                return (ScarfModel)((Object)this.model);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation getTexture() {
                return TEXTURE;
            }
        });
    }

    public static class FortuneBonusModifier
    extends LootModifier {
        protected FortuneBonusModifier(ILootCondition[] conditions) {
            super(conditions);
        }

        protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
            if (tool == null || tool.func_196082_o().func_74767_n("HasAppliedFortuneBonus")) {
                return generatedLoot;
            }
            Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
            BlockState blockState = (BlockState)context.func_216031_c(LootParameters.field_216287_g);
            if (blockState == null || !(entity instanceof LivingEntity) || !CuriosAPI.getCurioEquipped((Item)artifacts.common.init.Items.LUCKY_SCARF, (LivingEntity)((LivingEntity)entity)).isPresent()) {
                return generatedLoot;
            }
            ItemStack fakeTool = tool.func_190926_b() ? new ItemStack((IItemProvider)Items.field_221803_eL) : tool.func_77946_l();
            fakeTool.func_196082_o().func_74757_a("HasAppliedFortuneBonus", true);
            fakeTool.func_77966_a(Enchantments.field_185308_t, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)fakeTool) + 1);
            LootContext.Builder builder = new LootContext.Builder(context);
            builder.func_216015_a(LootParameters.field_216289_i, (Object)fakeTool);
            LootContext newContext = builder.func_216022_a(LootParameterSets.field_216267_h);
            LootTable lootTable = context.func_202879_g().func_73046_m().func_200249_aQ().func_186521_a(blockState.func_177230_c().func_220068_i());
            return lootTable.func_216113_a(newContext);
        }

        public static class Serializer
        extends GlobalLootModifierSerializer<FortuneBonusModifier> {
            public FortuneBonusModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
                return new FortuneBonusModifier(conditions);
            }
        }
    }
}

