/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.PendantModel;
import artifacts.common.init.Items;
import artifacts.common.item.ArtifactItem;
import artifacts.common.item.Curio;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosAPI;

public class PendantItem
extends ArtifactItem {
    private final ResourceLocation texture;

    public PendantItem(String name) {
        super(new Item.Properties(), name);
        this.texture = new ResourceLocation("artifacts", String.format("textures/entity/curio/%s.png", name));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return Curio.createProvider(new Curio(this){
            private Object model;

            @Override
            protected SoundEvent getEquipSound() {
                return SoundEvents.field_187716_o;
            }

            @OnlyIn(value=Dist.CLIENT)
            protected PendantModel getModel() {
                if (this.model == null) {
                    this.model = new PendantModel();
                }
                return (PendantModel)((Object)this.model);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation getTexture() {
                return PendantItem.this.texture;
            }
        });
    }

    @Mod.EventBusSubscriber(modid="artifacts")
    public static class Events {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            if (!event.getEntity().field_70170_p.field_72995_K && event.getAmount() >= 1.0f) {
                if (event.getSource() == DamageSource.field_180137_b && CuriosAPI.getCurioEquipped((Item)Items.SHOCK_PENDANT, (LivingEntity)event.getEntityLiving()).isPresent()) {
                    event.setCanceled(true);
                } else if (event.getSource().func_76346_g() instanceof LivingEntity) {
                    LivingEntity attacker;
                    if (CuriosAPI.getCurioEquipped((Item)Items.SHOCK_PENDANT, (LivingEntity)event.getEntityLiving()).isPresent() && attacker.field_70170_p.func_226660_f_((attacker = (LivingEntity)event.getSource().func_76346_g()).func_180425_c()) && event.getEntityLiving().func_70681_au().nextFloat() < 0.2f) {
                        ((ServerWorld)attacker.field_70170_p).func_217468_a(new LightningBoltEntity(attacker.field_70170_p, attacker.func_226277_ct_(), attacker.func_226278_cu_(), attacker.func_226281_cx_(), false));
                    }
                    if (CuriosAPI.getCurioEquipped((Item)Items.FLAME_PENDANT, (LivingEntity)event.getEntityLiving()).isPresent() && !(attacker = (LivingEntity)event.getSource().func_76346_g()).func_70045_F() && attacker.func_190631_cK() && event.getEntityLiving().func_70681_au().nextFloat() < 0.3f) {
                        attacker.func_70015_d(4);
                        attacker.func_70097_a(new EntityDamageSource("onFire", event.getEntity()).func_76361_j(), 2.0f);
                    }
                    if (CuriosAPI.getCurioEquipped((Item)Items.THORN_PENDANT, (LivingEntity)event.getEntityLiving()).isPresent() && (attacker = (LivingEntity)event.getSource().func_76346_g()).func_190631_cK() && field_77697_d.nextFloat() < 0.45f) {
                        attacker.func_70097_a(DamageSource.func_92087_a((Entity)event.getEntity()), (float)(1 + event.getEntityLiving().func_70681_au().nextInt(4)));
                    }
                }
            }
        }
    }
}

