/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.common.init.Items;
import artifacts.common.item.ArtifactItem;
import artifacts.common.item.Curio;
import artifacts.common.item.GloveCurio;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosAPI;

public class PocketPistonItem
extends ArtifactItem {
    private static final ResourceLocation TEXTURE_DEFAULT = new ResourceLocation("artifacts", "textures/entity/curio/pocket_piston_default.png");
    private static final ResourceLocation TEXTURE_SLIM = new ResourceLocation("artifacts", "textures/entity/curio/pocket_piston_slim.png");

    public PocketPistonItem() {
        super(new Item.Properties(), "pocket_piston");
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return Curio.createProvider(new GloveCurio(this){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation getSlimTexture() {
                return TEXTURE_SLIM;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation getTexture() {
                return TEXTURE_DEFAULT;
            }
        });
    }

    @Mod.EventBusSubscriber(modid="artifacts")
    public static class Events {
        @SubscribeEvent
        public static void onLivingKnockback(LivingKnockBackEvent event) {
            if (event.getAttacker() instanceof LivingEntity && CuriosAPI.getCurioEquipped((Item)Items.POCKET_PISTON, (LivingEntity)((LivingEntity)event.getAttacker())).isPresent()) {
                event.setStrength(event.getStrength() * 2.0f);
            }
        }
    }
}

