/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.SuperstitiousHatModel;
import artifacts.common.init.Items;
import artifacts.common.item.ArtifactItem;
import artifacts.common.item.Curio;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosAPI;

public class SuperstitiousHatItem
extends ArtifactItem {
    private static final ResourceLocation TEXTURE = new ResourceLocation("artifacts", "textures/entity/curio/superstitious_hat.png");

    public SuperstitiousHatItem() {
        super(new Item.Properties(), "superstitious_hat");
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return Curio.createProvider(new Curio(this){
            private Object model;

            @OnlyIn(value=Dist.CLIENT)
            protected SuperstitiousHatModel getModel() {
                if (this.model == null) {
                    this.model = new SuperstitiousHatModel();
                }
                return (SuperstitiousHatModel)((Object)this.model);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation getTexture() {
                return TEXTURE;
            }
        });
    }

    @Mod.EventBusSubscriber(modid="artifacts")
    public static class Events {
        @SubscribeEvent
        public static void onLootingLevel(LootingLevelEvent event) {
            Entity killerEntity = event.getDamageSource().func_76346_g();
            if (killerEntity instanceof LivingEntity && CuriosAPI.getCurioEquipped((Item)Items.SUPERSTITIOUS_HAT, (LivingEntity)((LivingEntity)killerEntity)).isPresent()) {
                event.setLootingLevel(event.getLootingLevel() + 1);
            }
        }
    }
}

