/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.common.init.Items;
import artifacts.common.item.ArtifactItem;
import java.util.UUID;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class UmbrellaItem
extends ArtifactItem {
    private static final AttributeModifier UMBRELLA_SLOW_FALLING = new AttributeModifier(UUID.fromString("a7a25453-2065-4a96-bc83-df600e13f390"), "artifacts:umbrella_slow_falling", -0.875, AttributeModifier.Operation.MULTIPLY_TOTAL).func_111168_a(false);

    public UmbrellaItem() {
        super(new Item.Properties(), "umbrella");
        this.func_185043_a(new ResourceLocation("blocking"), (stack, world, entity) -> entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f);
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)ArmorItem.field_96605_cw);
    }

    public boolean isShield(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BLOCK;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        return ActionResult.func_226249_b_((Object)itemstack);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="artifacts")
    public static class ClientEvents {
        @SubscribeEvent
        public static void onLivingRender(RenderLivingEvent.Pre<?, BipedModel<?>> event) {
            LivingEntity entity = event.getEntity();
            if (!entity.func_184587_cr() || entity.func_184607_cu().func_190926_b() || entity.func_184607_cu().func_77973_b().func_77661_b(entity.func_184607_cu()) != UseAction.BLOCK) {
                boolean isHoldingMainHand;
                boolean isHoldingOffHand = entity.func_184592_cb().func_77973_b() == Items.UMBRELLA;
                boolean bl = isHoldingMainHand = entity.func_184614_ca().func_77973_b() == Items.UMBRELLA;
                if (isHoldingMainHand && Minecraft.func_71410_x().field_71474_y.field_186715_A == HandSide.RIGHT || isHoldingOffHand && Minecraft.func_71410_x().field_71474_y.field_186715_A == HandSide.LEFT) {
                    ((BipedModel)event.getRenderer().func_217764_d()).field_187076_m = BipedModel.ArmPose.THROW_SPEAR;
                } else if (isHoldingMainHand && Minecraft.func_71410_x().field_71474_y.field_186715_A == HandSide.LEFT || isHoldingOffHand && Minecraft.func_71410_x().field_71474_y.field_186715_A == HandSide.RIGHT) {
                    ((BipedModel)event.getRenderer().func_217764_d()).field_187075_l = BipedModel.ArmPose.THROW_SPEAR;
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="artifacts")
    public static class Events {
        @SubscribeEvent
        public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
            LivingEntity entity = event.getEntityLiving();
            IAttributeInstance gravity = entity.func_110148_a(LivingEntity.ENTITY_GRAVITY);
            if (!(entity.field_70122_E || entity.func_70090_H() || !(event.getEntity().func_213322_ci().field_72448_b < 0.0) || entity.func_70644_a(Effects.field_204839_B) || entity.func_184592_cb().func_77973_b() != Items.UMBRELLA && entity.func_184614_ca().func_77973_b() != Items.UMBRELLA || entity.func_184587_cr() && !entity.func_184607_cu().func_190926_b() && entity.func_184607_cu().func_77973_b().func_77661_b(entity.func_184607_cu()) == UseAction.BLOCK)) {
                if (!gravity.func_180374_a(UMBRELLA_SLOW_FALLING)) {
                    gravity.func_111121_a(UMBRELLA_SLOW_FALLING);
                }
                entity.field_70143_R = 0.0f;
            } else if (gravity.func_180374_a(UMBRELLA_SLOW_FALLING)) {
                gravity.func_111124_b(UMBRELLA_SLOW_FALLING);
            }
        }
    }
}

