/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.world;

import artifacts.common.config.Config;
import artifacts.common.entity.MimicEntity;
import artifacts.common.init.Entities;
import artifacts.common.init.LootTables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.EndRodBlock;
import net.minecraft.block.LanternBlock;
import net.minecraft.entity.Entity;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.Tags;

public class CampsiteFeature
extends Feature<NoFeatureConfig> {
    public static final BlockStateProvider CRAFTING_STATION_PROVIDER = new WeightedBlockStateProvider().func_227407_a_(Blocks.field_150462_ai.func_176223_P(), 5).func_227407_a_(Blocks.field_150460_al.func_176223_P(), 5).func_227407_a_(Blocks.field_222424_lM.func_176223_P(), 5).func_227407_a_(Blocks.field_222423_lL.func_176223_P(), 5).func_227407_a_(Blocks.field_222429_lR.func_176223_P(), 5).func_227407_a_(Blocks.field_222426_lO.func_176223_P(), 5).func_227407_a_(Blocks.field_222425_lN.func_176223_P(), 5).func_227407_a_(Blocks.field_150467_bQ.func_176223_P(), 2).func_227407_a_(Blocks.field_196717_eY.func_176223_P(), 2).func_227407_a_(Blocks.field_196718_eZ.func_176223_P(), 1);
    public static final BlockStateProvider DECORATION_PROVIDER = new WeightedBlockStateProvider().func_227407_a_(Blocks.field_222432_lU.func_176223_P(), 5).func_227407_a_(Blocks.field_150478_aa.func_176223_P(), 3).func_227407_a_(Blocks.field_150429_aA.func_176223_P(), 3).func_227407_a_(Blocks.field_150414_aQ.func_176223_P(), 1).func_227407_a_(Blocks.field_150382_bo.func_176223_P(), 4);
    public static final BlockStateProvider ORE_PROVIDER = new WeightedBlockStateProvider().func_227407_a_(Blocks.field_150366_p.func_176223_P(), 6).func_227407_a_(Blocks.field_150450_ax.func_176223_P(), 6).func_227407_a_(Blocks.field_150369_x.func_176223_P(), 6).func_227407_a_(Blocks.field_150352_o.func_176223_P(), 4).func_227407_a_(Blocks.field_150482_ag.func_176223_P(), 2).func_227407_a_(Blocks.field_150412_bA.func_176223_P(), 1);

    public CampsiteFeature() {
        super(NoFeatureConfig::func_214639_a);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos pos, NoFeatureConfig config) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-3, 0, -3), (BlockPos)pos.func_177982_a(3, 0, 3)).forEach(blockPos -> positions.add(blockPos.func_185334_h()));
        positions.remove(pos);
        positions.removeIf(currentPos -> !world.func_175623_d(currentPos));
        positions.removeIf(currentPos -> !world.func_180495_p(currentPos.func_177977_b()).func_185904_a().func_76230_c());
        if (positions.size() < 12) {
            return false;
        }
        Collections.shuffle(positions);
        if ((double)random.nextFloat() < Config.campsiteOreChance) {
            this.generateOreVein(world, pos.func_177977_b(), random);
        }
        this.generateLightSource(world, pos, random);
        this.generateContainer(world, (BlockPos)positions.remove(0), random);
        if (random.nextBoolean()) {
            this.generateContainer(world, (BlockPos)positions.remove(0), random);
        }
        this.generateCraftingStation(world, (BlockPos)positions.remove(0), random);
        if (random.nextBoolean()) {
            this.generateCraftingStation(world, (BlockPos)positions.remove(0), random);
        }
        return true;
    }

    public void generateLightSource(IWorld world, BlockPos pos, Random random) {
        if (random.nextInt(4) != 0) {
            BlockPos currentPos = pos;
            while (currentPos.func_177956_o() - pos.func_177956_o() < 8 && world.func_175623_d(currentPos.func_177984_a())) {
                currentPos = currentPos.func_177984_a();
            }
            if (currentPos.func_177956_o() - pos.func_177956_o() > 2 && !world.func_175623_d(currentPos.func_177984_a())) {
                if (random.nextInt(12) == 0) {
                    world.func_180501_a(currentPos, (BlockState)Blocks.field_185764_cQ.func_176223_P().func_206870_a((IProperty)EndRodBlock.field_176387_N, (Comparable)Direction.DOWN), 2);
                } else {
                    world.func_180501_a(currentPos, (BlockState)Blocks.field_222432_lU.func_176223_P().func_206870_a((IProperty)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(true)), 2);
                }
                return;
            }
        }
        world.func_180501_a(pos, (BlockState)Blocks.field_222433_lV.func_176223_P().func_206870_a((IProperty)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(random.nextInt(3) != 0)), 2);
    }

    public void generateContainer(IWorld world, BlockPos pos, Random random) {
        if ((double)random.nextFloat() < Config.campsiteMimicChance) {
            MimicEntity mimic = (MimicEntity)Entities.MIMIC.func_200721_a(world.func_201672_e());
            if (mimic != null) {
                mimic.setDormant();
                mimic.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                world.func_217376_c((Entity)mimic);
            }
        } else {
            if (random.nextBoolean()) {
                if (random.nextInt(4) == 0) {
                    world.func_180501_a(pos, (BlockState)Blocks.field_150447_bR.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)Direction.Plane.HORIZONTAL.func_179518_a(random)), 2);
                    world.func_180501_a(pos.func_177977_b(), Blocks.field_150335_W.func_176223_P(), 0);
                }
                world.func_180501_a(pos, (BlockState)((Block)Tags.Blocks.CHESTS_WOODEN.func_205596_a(random)).func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)Direction.Plane.HORIZONTAL.func_179518_a(random)), 2);
            } else {
                world.func_180501_a(pos, (BlockState)Blocks.field_222422_lK.func_176223_P().func_206870_a((IProperty)BarrelBlock.field_220092_a, (Comparable)Direction.func_176741_a((Random)random)), 2);
            }
            TileEntity container = world.func_175625_s(pos);
            if (container instanceof LockableLootTileEntity) {
                ((LockableLootTileEntity)container).func_189404_a(LootTables.CAMPSITE_CHEST, random.nextLong());
            }
        }
    }

    public void generateCraftingStation(IWorld world, BlockPos pos, Random random) {
        BlockState state = CRAFTING_STATION_PROVIDER.func_225574_a_(random, pos);
        world.func_180501_a(pos, state, 0);
        if (random.nextBoolean() && world.func_175623_d(pos.func_177984_a())) {
            this.generateDecoration(world, pos.func_177984_a(), random);
        }
    }

    public void generateDecoration(IWorld world, BlockPos pos, Random random) {
        if (random.nextBoolean()) {
            world.func_180501_a(pos, DECORATION_PROVIDER.func_225574_a_(random, pos), 2);
            return;
        }
        world.func_180501_a(pos, ((Block)BlockTags.field_200032_i.func_205596_a(random)).func_176223_P(), 2);
    }

    public void generateOreVein(IWorld world, BlockPos pos, Random random) {
        BlockState ore = ORE_PROVIDER.func_225574_a_(random, pos);
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        positions.add(pos);
        for (int i = 4 + random.nextInt(12); i > 0; --i) {
            pos = (BlockPos)positions.remove(0);
            world.func_180501_a(pos, ore, 2);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (!world.func_180495_p(pos.func_177972_a(direction)).func_185904_a().func_76230_c() || world.func_180495_p(pos.func_177972_a(direction).func_177984_a()).func_185904_a().func_76230_c()) continue;
                positions.add(pos.func_177972_a(direction));
            }
            if (positions.size() != 0) continue;
            return;
        }
    }
}

