/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    final ForgeConfigSpec.ConfigValue<List<String>> biomeBlacklist;
    final ForgeConfigSpec.IntValue campsiteChance;
    final ForgeConfigSpec.IntValue campsiteMimicChance;
    final ForgeConfigSpec.IntValue campsiteOreChance;
    final ForgeConfigSpec.IntValue campsiteMinY;
    final ForgeConfigSpec.IntValue campsiteMaxY;
    final ForgeConfigSpec.BooleanValue useModdedChests;
    final ForgeConfigSpec.IntValue everlastingFoodCooldown;

    CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("campsite");
        this.biomeBlacklist = builder.worldRestart().comment("List of biome IDs in which campsites are not allowed to generate. End and nether biomes are excluded by default.").translation("artifacts.config.biome_blacklist").define("biome_blacklist", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:void"}));
        this.campsiteChance = builder.worldRestart().comment("Per-chunk probability (as a percentage) a campsite is attempted to be generated. Not every attempt succeeds, this also depends on the density and shape of caves").translation("artifacts.config.campsite_chance").defineInRange("campsite_chance", 8, 0, 100);
        this.campsiteMinY = builder.comment("The minimum y-level at which a campsite can generate").translation("artifacts.config.campsite_min_y").defineInRange("campsite_min_y", 0, 0, 255);
        this.campsiteMaxY = builder.comment("The maximum y-level at which a campsite can generate").translation("artifacts.config.campsite_max_y").defineInRange("campsite_max_y", 45, 0, 255);
        this.campsiteMimicChance = builder.comment("Probability for a container of a campsite to be replaced by a mimic").translation("artifacts.config.campsite_mimic_chance").defineInRange("campsite_mimic_chance", 30, 0, 100);
        this.campsiteOreChance = builder.comment("Probability for an ore vein to generate underneath a campsite").translation("artifacts.config.campsite_ore_chance").defineInRange("campsite_ore_chance", 25, 0, 100);
        this.useModdedChests = builder.comment("Whether to use wooden chests from other mods when generating campsites, may make it easier to distinguish them from mimics").translation("artifacts.config.use_modded_chests").define("use_modded_chests", true);
        builder.pop();
        builder.push("items");
        this.everlastingFoodCooldown = builder.comment("Cooldown in ticks for the Everlasting Beef and Eternal Steak items").translation("artifacts.config.eternal_food_cooldown").defineInRange("eternal_food_cooldown", 300, 0, Integer.MAX_VALUE);
        builder.pop();
    }
}

