/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.config;

import artifacts.common.config.CommonConfig;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="artifacts", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    public static final ForgeConfigSpec COMMON_SPEC;
    private static final CommonConfig COMMON;
    public static Set<ResourceLocation> biomeBlacklist;
    public static int campsiteChance;
    public static int campsiteMinY;
    public static int campsiteMaxY;
    public static double campsiteMimicChance;
    public static double campsiteOreChance;
    public static boolean useModdedChests;
    public static int everlastingFoodCooldown;

    public static void bakeCommon() {
        biomeBlacklist = ((List)Config.COMMON.biomeBlacklist.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet());
        campsiteChance = (Integer)Config.COMMON.campsiteChance.get();
        campsiteMimicChance = (double)((Integer)Config.COMMON.campsiteMimicChance.get()).intValue() / 100.0;
        campsiteOreChance = (double)((Integer)Config.COMMON.campsiteOreChance.get()).intValue() / 100.0;
        campsiteMinY = (Integer)Config.COMMON.campsiteMinY.get();
        campsiteMaxY = (Integer)Config.COMMON.campsiteMaxY.get();
        useModdedChests = (Boolean)Config.COMMON.useModdedChests.get();
        everlastingFoodCooldown = (Integer)Config.COMMON.everlastingFoodCooldown.get();
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            Config.bakeCommon();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON = (CommonConfig)specPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
    }
}

