/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.BunnyHoppersModel;
import artifacts.common.item.ArtifactItem;
import artifacts.common.item.Curio;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class BunnyHoppersItem
extends ArtifactItem {
    private static final ResourceLocation TEXTURE = new ResourceLocation("artifacts", "textures/entity/curio/bunny_hoppers.png");

    public BunnyHoppersItem() {
        super(new Item.Properties(), "bunny_hoppers");
        MinecraftForge.EVENT_BUS.addListener(this::onLivingDamage);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingFall);
    }

    public void onLivingDamage(LivingDamageEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && CuriosApi.getCuriosHelper().findEquippedCurio((Item)this, event.getEntityLiving()).isPresent()) {
            event.getEntity().field_70170_p.func_184148_a(null, event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_(), event.getEntityLiving().func_226281_cx_(), SoundEvents.field_187822_em, SoundCategory.PLAYERS, 1.0f, (event.getEntityLiving().func_70681_au().nextFloat() - event.getEntityLiving().func_70681_au().nextFloat()) * 0.2f + 1.0f);
        }
    }

    public void onLivingFall(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && CuriosApi.getCuriosHelper().findEquippedCurio((Item)this, event.getEntityLiving()).isPresent()) {
            event.setDamageMultiplier(0.0f);
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return Curio.createProvider(new Curio(this){
            private Object model;

            public void curioTick(String identifier, int index, LivingEntity livingEntity) {
                if (!livingEntity.field_70170_p.field_72995_K && livingEntity.field_70173_aa % 15 == 0) {
                    livingEntity.func_195064_c(new EffectInstance(Effects.field_76430_j, 39, 1, true, false));
                }
            }

            @OnlyIn(value=Dist.CLIENT)
            protected BunnyHoppersModel getModel() {
                if (this.model == null) {
                    this.model = new BunnyHoppersModel();
                }
                return (BunnyHoppersModel)((Object)this.model);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation getTexture() {
                return TEXTURE;
            }
        });
    }
}

