/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.CrystalHeartModel;
import artifacts.common.item.ArtifactItem;
import artifacts.common.item.Curio;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class CrystalHeartItem
extends ArtifactItem {
    private static final ResourceLocation TEXTURE = new ResourceLocation("artifacts", "textures/entity/curio/crystal_heart.png");
    private static final AttributeModifier HEALTH_BONUS = new AttributeModifier(UUID.fromString("99fa0537-90b9-481a-bc76-4650987faba3"), "artifacts:crystal_heart_health_bonus", 10.0, AttributeModifier.Operation.ADDITION);

    public CrystalHeartItem() {
        super(new Item.Properties(), "crystal_heart");
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return Curio.createProvider(new Curio(this){
            private Object model;

            public void onEquip(String identifier, int index, LivingEntity entity) {
                ModifiableAttributeInstance health;
                if (!entity.field_70170_p.func_201670_d() && (health = entity.func_110148_a(Attributes.field_233818_a_)) != null && !health.func_180374_a(HEALTH_BONUS)) {
                    health.func_233769_c_(HEALTH_BONUS);
                }
            }

            public void onUnequip(String identifier, int index, LivingEntity entity) {
                ModifiableAttributeInstance health;
                if (!entity.field_70170_p.func_201670_d() && (health = entity.func_110148_a(Attributes.field_233818_a_)) != null && health.func_180374_a(HEALTH_BONUS)) {
                    health.func_111124_b(HEALTH_BONUS);
                    if (entity.func_110143_aJ() > entity.func_110138_aP()) {
                        entity.func_70606_j(entity.func_110138_aP());
                    }
                }
            }

            @OnlyIn(value=Dist.CLIENT)
            protected CrystalHeartModel getModel() {
                if (this.model == null) {
                    this.model = new CrystalHeartModel();
                }
                return (CrystalHeartModel)((Object)this.model);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation getTexture() {
                return TEXTURE;
            }
        });
    }
}

