/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.ClawsModel;
import artifacts.common.item.ArtifactItem;
import artifacts.common.item.Curio;
import artifacts.common.item.GloveCurio;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.PlayerEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class DiggingClawsItem
extends ArtifactItem {
    private static final ResourceLocation TEXTURE_DEFAULT = new ResourceLocation("artifacts", "textures/entity/curio/digging_claws_default.png");
    private static final ResourceLocation TEXTURE_SLIM = new ResourceLocation("artifacts", "textures/entity/curio/digging_claws_default.png");

    public DiggingClawsItem() {
        super(new Item.Properties(), "digging_claws");
        MinecraftForge.EVENT_BUS.addListener(this::onBreakSpeed);
        MinecraftForge.EVENT_BUS.addListener(this::onHarvestCheck);
    }

    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)this, event.getEntityLiving()).isPresent()) {
            event.setNewSpeed(event.getNewSpeed() + 4.0f);
        }
    }

    public void onHarvestCheck(PlayerEvent.HarvestCheck event) {
        if (!event.canHarvest() && CuriosApi.getCuriosHelper().findEquippedCurio((Item)this, event.getEntityLiving()).isPresent()) {
            event.setCanHarvest(event.canHarvest() || event.getTargetBlock().getHarvestLevel() <= 2);
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return Curio.createProvider(new GloveCurio(this){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation getTexture() {
                return TEXTURE_DEFAULT;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation getSlimTexture() {
                return TEXTURE_SLIM;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ClawsModel getSlimModel() {
                if (this.modelSlim == null) {
                    this.modelSlim = new ClawsModel(true);
                }
                return (ClawsModel)((Object)this.modelSlim);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ClawsModel getModel() {
                if (this.modelDefault == null) {
                    this.modelDefault = new ClawsModel(false);
                }
                return (ClawsModel)((Object)this.modelDefault);
            }
        });
    }
}

