/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.DrinkingHatModel;
import artifacts.common.item.ArtifactItem;
import artifacts.common.item.Curio;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class DrinkingHatItem
extends ArtifactItem {
    private final ResourceLocation texture;

    public DrinkingHatItem(String name, ResourceLocation texture) {
        super(new Item.Properties(), name);
        this.texture = texture;
        MinecraftForge.EVENT_BUS.addListener(this::onItemUseStart);
    }

    public void onItemUseStart(LivingEntityUseItemEvent.Start event) {
        if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)this, event.getEntityLiving()).isPresent() && event.getItem().func_77975_n() == UseAction.DRINK) {
            event.setDuration(event.getDuration() / 4);
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return Curio.createProvider(new Curio(this){
            private Object model;

            @Override
            protected SoundEvent getEquipSound() {
                return SoundEvents.field_187615_H;
            }

            @OnlyIn(value=Dist.CLIENT)
            protected DrinkingHatModel getModel() {
                if (this.model == null) {
                    this.model = new DrinkingHatModel();
                }
                return (DrinkingHatModel)((Object)this.model);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation getTexture() {
                return DrinkingHatItem.this.texture;
            }
        });
    }
}

