/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.RenderTypes;
import artifacts.client.render.model.curio.GloveModel;
import artifacts.common.item.ArtifactItem;
import artifacts.common.item.Curio;
import artifacts.common.item.GloveCurio;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class FireGauntletItem
extends ArtifactItem {
    private static final ResourceLocation TEXTURE_DEFAULT = new ResourceLocation("artifacts", "textures/entity/curio/fire_gauntlet_default.png");
    private static final ResourceLocation TEXTURE_SLIM = new ResourceLocation("artifacts", "textures/entity/curio/fire_gauntlet_slim.png");
    private static final ResourceLocation TEXTURE_DEFAULT_GLOW = new ResourceLocation("artifacts", "textures/entity/curio/fire_gauntlet_default_glow.png");
    private static final ResourceLocation TEXTURE_SLIM_GLOW = new ResourceLocation("artifacts", "textures/entity/curio/fire_gauntlet_slim_glow.png");

    public FireGauntletItem() {
        super(new Item.Properties(), "fire_gauntlet");
        MinecraftForge.EVENT_BUS.addListener(this::onLivingHurt);
    }

    public void onLivingHurt(LivingHurtEvent event) {
        if (event.getSource() instanceof EntityDamageSource && !(event.getSource() instanceof IndirectEntityDamageSource) && !((EntityDamageSource)event.getSource()).func_180139_w() && event.getSource().func_76346_g() instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
            if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)this, attacker).isPresent() && !event.getEntity().func_230279_az_()) {
                event.getEntity().func_70015_d(8);
            }
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return Curio.createProvider(new GloveCurio(this){

            @Override
            protected SoundEvent getEquipSound() {
                return SoundEvents.field_187725_r;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                boolean smallArms = 1.hasSmallArms((Entity)entity);
                GloveModel model = this.getModel(smallArms);
                model.func_225597_a_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                model.func_212843_a_(entity, limbSwing, limbSwingAmount, partialTicks);
                ICurio.RenderHelper.followBodyRotations((LivingEntity)entity, (BipedModel[])new BipedModel[]{model});
                IVertexBuilder vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)model.func_228282_a_(this.getTexture(smallArms)), (boolean)false, (boolean)false);
                model.renderHand(index == 0, matrixStack, vertexBuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)RenderTypes.unlit(this.getGlowTexture(smallArms)), (boolean)false, (boolean)false);
                model.renderHand(index == 0, matrixStack, vertexBuilder, 0xF000F0, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation getTexture() {
                return TEXTURE_DEFAULT;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation getSlimTexture() {
                return TEXTURE_SLIM;
            }

            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation getGlowTexture(boolean smallArms) {
                return smallArms ? TEXTURE_SLIM_GLOW : TEXTURE_DEFAULT_GLOW;
            }
        });
    }
}

