/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.FlippersModel;
import artifacts.common.item.ArtifactItem;
import artifacts.common.item.Curio;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class FlippersItem
extends ArtifactItem {
    private static final ResourceLocation TEXTURE = new ResourceLocation("artifacts", "textures/entity/curio/flippers.png");
    private static final AttributeModifier FLIPPER_SWIM_SPEED = new AttributeModifier(UUID.fromString("63f1bb32-d301-419b-ab52-5d1af94eed1d"), "artifacts:flipper_swim_speed", 1.0, AttributeModifier.Operation.ADDITION);

    public FlippersItem() {
        super(new Item.Properties(), "flippers");
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return Curio.createProvider(new Curio(this){
            private Object model;

            public Multimap<Attribute, AttributeModifier> getAttributeModifiers(String identifier) {
                Multimap result = super.getAttributeModifiers(identifier);
                result.put((Object)ForgeMod.SWIM_SPEED.get(), (Object)FLIPPER_SWIM_SPEED);
                return result;
            }

            @OnlyIn(value=Dist.CLIENT)
            protected FlippersModel getModel() {
                if (this.model == null) {
                    this.model = new FlippersModel();
                }
                return (FlippersModel)((Object)this.model);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation getTexture() {
                return TEXTURE;
            }
        });
    }
}

