/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.PendantModel;
import artifacts.common.item.ArtifactItem;
import artifacts.common.item.Curio;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public abstract class PendantItem
extends ArtifactItem {
    private final ResourceLocation texture;

    public PendantItem(String name) {
        super(new Item.Properties(), name);
        this.texture = new ResourceLocation("artifacts", String.format("textures/entity/curio/%s.png", name));
        MinecraftForge.EVENT_BUS.addListener(this::onLivingHurt);
    }

    public abstract void onLivingHurt(LivingHurtEvent var1);

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return Curio.createProvider(new Curio(this){
            private Object model;

            @Override
            protected SoundEvent getEquipSound() {
                return SoundEvents.field_187716_o;
            }

            @OnlyIn(value=Dist.CLIENT)
            protected PendantModel getModel() {
                if (this.model == null) {
                    this.model = new PendantModel();
                }
                return (PendantModel)((Object)this.model);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation getTexture() {
                return PendantItem.this.texture;
            }
        });
    }
}

