/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.common.item.ArtifactItem;
import artifacts.common.item.Curio;
import artifacts.common.item.GloveCurio;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class PocketPistonItem
extends ArtifactItem {
    private static final ResourceLocation TEXTURE_DEFAULT = new ResourceLocation("artifacts", "textures/entity/curio/pocket_piston_default.png");
    private static final ResourceLocation TEXTURE_SLIM = new ResourceLocation("artifacts", "textures/entity/curio/pocket_piston_slim.png");

    public PocketPistonItem() {
        super(new Item.Properties(), "pocket_piston");
        MinecraftForge.EVENT_BUS.addListener(this::onLivingAttack);
    }

    public void onLivingAttack(LivingAttackEvent event) {
        if (event.getSource().func_76346_g() instanceof LivingEntity && CuriosApi.getCuriosHelper().findEquippedCurio((Item)this, (LivingEntity)event.getSource().func_76346_g()).isPresent()) {
            LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
            event.getEntityLiving().func_233627_a_(1.5f, (double)MathHelper.func_76126_a((float)((float)((double)attacker.field_70177_z * (Math.PI / 180)))), (double)(-MathHelper.func_76134_b((float)((float)((double)attacker.field_70177_z * (Math.PI / 180))))));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return Curio.createProvider(new GloveCurio(this){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation getSlimTexture() {
                return TEXTURE_SLIM;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation getTexture() {
                return TEXTURE_DEFAULT;
            }
        });
    }
}

