/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.RunningShoesModel;
import artifacts.common.item.ArtifactItem;
import artifacts.common.item.Curio;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class RunningShoesItem
extends ArtifactItem {
    private static final ResourceLocation TEXTURE = new ResourceLocation("artifacts", "textures/entity/curio/running_shoes.png");
    private static final AttributeModifier RUNNING_SHOES_SPEED_BOOST = new AttributeModifier(UUID.fromString("ac7ab816-2b08-46b6-879d-e5dea34ff305"), "artifacts:running_shoes_movement_speed", 0.4, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public RunningShoesItem() {
        super(new Item.Properties(), "running_shoes");
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return Curio.createProvider(new Curio(this){
            private Object model;

            @OnlyIn(value=Dist.CLIENT)
            protected RunningShoesModel getModel() {
                if (this.model == null) {
                    this.model = new RunningShoesModel();
                }
                return (RunningShoesModel)((Object)this.model);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation getTexture() {
                return TEXTURE;
            }

            public void curioTick(String identifier, int index, LivingEntity livingEntity) {
                ModifiableAttributeInstance movementSpeed = livingEntity.func_110148_a(Attributes.field_233821_d_);
                if (livingEntity.func_70051_ag()) {
                    if (!movementSpeed.func_180374_a(RUNNING_SHOES_SPEED_BOOST)) {
                        movementSpeed.func_233767_b_(RUNNING_SHOES_SPEED_BOOST);
                    }
                    if (livingEntity instanceof PlayerEntity) {
                        livingEntity.field_70138_W = Math.max(livingEntity.field_70138_W, 1.1f);
                    }
                } else if (movementSpeed.func_180374_a(RUNNING_SHOES_SPEED_BOOST)) {
                    movementSpeed.func_111124_b(RUNNING_SHOES_SPEED_BOOST);
                    livingEntity.field_70138_W = 0.6f;
                }
            }

            public void onUnequip(String identifier, int index, LivingEntity livingEntity) {
                ModifiableAttributeInstance movementSpeed = livingEntity.func_110148_a(Attributes.field_233821_d_);
                if (movementSpeed.func_180374_a(RUNNING_SHOES_SPEED_BOOST)) {
                    movementSpeed.func_111124_b(RUNNING_SHOES_SPEED_BOOST);
                    livingEntity.field_70138_W = 0.6f;
                }
            }
        });
    }
}

