/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.UniversalAttractorModel;
import artifacts.common.item.ArtifactItem;
import artifacts.common.item.Curio;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class UniversalAttractorItem
extends ArtifactItem {
    private static final ResourceLocation TEXTURE = new ResourceLocation("artifacts", "textures/entity/curio/universal_attractor.png");

    public UniversalAttractorItem() {
        super(new Item.Properties(), "universal_attractor");
        MinecraftForge.EVENT_BUS.addListener(this::onItemToss);
    }

    public void onItemToss(ItemTossEvent event) {
        CuriosApi.getCuriosHelper().findEquippedCurio((Item)this, (LivingEntity)event.getPlayer()).ifPresent(triple -> UniversalAttractorItem.setCooldown((ItemStack)triple.right, 100));
    }

    public static int getCooldown(ItemStack stack) {
        return stack.func_196082_o().func_74762_e("Cooldown");
    }

    public static void setCooldown(ItemStack stack, int cooldown) {
        stack.func_196082_o().func_74768_a("Cooldown", cooldown);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundNBT nbt) {
        return Curio.createProvider(new Curio(this){
            private Object model;

            public void curioTick(String identifier, int index, LivingEntity entity) {
                if (entity.func_175149_v() || !(entity instanceof PlayerEntity)) {
                    return;
                }
                int cooldown = UniversalAttractorItem.getCooldown(stack);
                if (cooldown <= 0) {
                    Vector3d playerPos = entity.func_213303_ch().func_72441_c(0.0, 0.75, 0.0);
                    int range = 5;
                    List items = entity.field_70170_p.func_217357_a(ItemEntity.class, new AxisAlignedBB(playerPos.field_72450_a - (double)range, playerPos.field_72448_b - (double)range, playerPos.field_72449_c - (double)range, playerPos.field_72450_a + (double)range, playerPos.field_72448_b + (double)range, playerPos.field_72449_c + (double)range));
                    int pulled = 0;
                    for (ItemEntity item : items) {
                        if (!item.func_70089_S() || item.func_174874_s() || item.getPersistentData().func_74767_n("PreventRemoteMovement")) continue;
                        if (pulled++ <= 200) {
                            Vector3d motion = playerPos.func_178788_d(item.func_213303_ch().func_72441_c(0.0, (double)(item.func_213302_cg() / 2.0f), 0.0));
                            if (Math.sqrt(motion.field_72450_a * motion.field_72450_a + motion.field_72448_b * motion.field_72448_b + motion.field_72449_c * motion.field_72449_c) > 1.0) {
                                motion = motion.func_72432_b();
                            }
                            item.func_213317_d(motion.func_186678_a(0.6));
                            continue;
                        }
                        break;
                    }
                } else {
                    UniversalAttractorItem.setCooldown(stack, cooldown - 1);
                }
            }

            @OnlyIn(value=Dist.CLIENT)
            protected UniversalAttractorModel getModel() {
                if (this.model == null) {
                    this.model = new UniversalAttractorModel();
                }
                return (UniversalAttractorModel)((Object)this.model);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation getTexture() {
                return TEXTURE;
            }
        });
    }
}

