/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.world;

import artifacts.common.config.Config;
import artifacts.common.entity.MimicEntity;
import artifacts.common.init.Entities;
import artifacts.common.init.LootTables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.BlastFurnaceBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.EndRodBlock;
import net.minecraft.block.FurnaceBlock;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.SmokerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.Tags;

public class CampsiteFeature
extends Feature<NoFeatureConfig> {
    public static final BlockStateProvider CRAFTING_STATION_PROVIDER = new WeightedBlockStateProvider().func_227407_a_(Blocks.field_150462_ai.func_176223_P(), 5).func_227407_a_((BlockState)Blocks.field_150460_al.func_176223_P().func_206870_a((Property)FurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(false)), 5).func_227407_a_((BlockState)Blocks.field_222424_lM.func_176223_P().func_206870_a((Property)BlastFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(false)), 5).func_227407_a_((BlockState)Blocks.field_222423_lL.func_176223_P().func_206870_a((Property)SmokerBlock.field_220091_b, (Comparable)Boolean.valueOf(false)), 5).func_227407_a_(Blocks.field_222429_lR.func_176223_P(), 5).func_227407_a_(Blocks.field_222426_lO.func_176223_P(), 5).func_227407_a_(Blocks.field_222425_lN.func_176223_P(), 5).func_227407_a_(Blocks.field_150467_bQ.func_176223_P(), 2).func_227407_a_(Blocks.field_196717_eY.func_176223_P(), 2).func_227407_a_(Blocks.field_196718_eZ.func_176223_P(), 1);
    public static final BlockStateProvider DECORATION_PROVIDER = new WeightedBlockStateProvider().func_227407_a_(Blocks.field_222432_lU.func_176223_P(), 5).func_227407_a_(Blocks.field_150478_aa.func_176223_P(), 3).func_227407_a_(Blocks.field_150429_aA.func_176223_P(), 3).func_227407_a_(Blocks.field_150414_aQ.func_176223_P(), 1).func_227407_a_(Blocks.field_150382_bo.func_176223_P(), 4);
    public static final BlockStateProvider ORE_PROVIDER = new WeightedBlockStateProvider().func_227407_a_(Blocks.field_150366_p.func_176223_P(), 6).func_227407_a_(Blocks.field_150450_ax.func_176223_P(), 6).func_227407_a_(Blocks.field_150369_x.func_176223_P(), 6).func_227407_a_(Blocks.field_150352_o.func_176223_P(), 4).func_227407_a_(Blocks.field_150482_ag.func_176223_P(), 2).func_227407_a_(Blocks.field_150412_bA.func_176223_P(), 1);
    public static final BlockStateProvider CAMPFIRE_PROVIDER = new WeightedBlockStateProvider().func_227407_a_((BlockState)Blocks.field_222433_lV.func_176223_P().func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(false)), 12).func_227407_a_((BlockState)Blocks.field_222433_lV.func_176223_P().func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(true)), 3).func_227407_a_((BlockState)Blocks.field_235367_mf_.func_176223_P().func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(true)), 1);
    public static final BlockStateProvider LANTERN_PROVIDER = new WeightedBlockStateProvider().func_227407_a_((BlockState)Blocks.field_222432_lU.func_176223_P().func_206870_a((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(true)), 6).func_227407_a_((BlockState)Blocks.field_235366_md_.func_176223_P().func_206870_a((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(true)), 2).func_227407_a_((BlockState)Blocks.field_185764_cQ.func_176223_P().func_206870_a((Property)EndRodBlock.field_176387_N, (Comparable)Direction.DOWN), 1).func_227407_a_(Blocks.field_235383_mw_.func_176223_P(), 1).func_227407_a_(Blocks.field_150426_aN.func_176223_P(), 1);

    public CampsiteFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig featureConfig) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-3, 0, -3), (BlockPos)pos.func_177982_a(3, 0, 3)).forEach(blockPos -> positions.add(blockPos.func_185334_h()));
        positions.remove(pos);
        positions.removeIf(currentPos -> !world.func_175623_d(currentPos));
        positions.removeIf(currentPos -> !world.func_180495_p(currentPos.func_177977_b()).func_185904_a().func_76230_c());
        if (positions.size() < 12) {
            return false;
        }
        Collections.shuffle(positions);
        if ((double)random.nextFloat() < Config.campsiteOreChance) {
            this.generateOreVein(world, pos.func_177977_b(), random);
        }
        this.generateLightSource(world, pos, random);
        this.generateContainer(world, (BlockPos)positions.remove(0), random);
        if (random.nextBoolean()) {
            this.generateContainer(world, (BlockPos)positions.remove(0), random);
        }
        this.generateCraftingStation(world, (BlockPos)positions.remove(0), random);
        if (random.nextBoolean()) {
            this.generateCraftingStation(world, (BlockPos)positions.remove(0), random);
        }
        return true;
    }

    public void generateLightSource(ISeedReader world, BlockPos pos, Random random) {
        if (random.nextInt(4) != 0) {
            BlockPos currentPos = pos;
            while (currentPos.func_177956_o() - pos.func_177956_o() < 8 && world.func_175623_d(currentPos.func_177984_a())) {
                currentPos = currentPos.func_177984_a();
            }
            if (currentPos.func_177956_o() - pos.func_177956_o() > 2 && !world.func_175623_d(currentPos.func_177984_a())) {
                this.func_230367_a_((IWorldWriter)world, currentPos, LANTERN_PROVIDER.func_225574_a_(random, currentPos));
                return;
            }
        }
        this.func_230367_a_((IWorldWriter)world, pos, CAMPFIRE_PROVIDER.func_225574_a_(random, pos));
    }

    public void generateContainer(ISeedReader world, BlockPos pos, Random random) {
        if ((double)random.nextFloat() < Config.campsiteMimicChance) {
            MimicEntity mimic = (MimicEntity)Entities.MIMIC.func_200721_a((World)world.func_201672_e());
            if (mimic != null) {
                mimic.setDormant();
                mimic.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                world.func_217376_c((Entity)mimic);
            }
        } else {
            if (random.nextBoolean()) {
                if (random.nextInt(5) == 0) {
                    this.func_230367_a_((IWorldWriter)world, pos, (BlockState)Blocks.field_150447_bR.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)Direction.Plane.HORIZONTAL.func_179518_a(random)));
                    this.func_230367_a_((IWorldWriter)world, pos.func_177977_b(), Blocks.field_150335_W.func_176223_P());
                } else {
                    Block chestBlock = Config.useModdedChests ? (Block)Tags.Blocks.CHESTS_WOODEN.func_205596_a(random) : Blocks.field_150486_ae;
                    this.func_230367_a_((IWorldWriter)world, pos, (BlockState)chestBlock.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)Direction.Plane.HORIZONTAL.func_179518_a(random)));
                }
            } else {
                this.func_230367_a_((IWorldWriter)world, pos, (BlockState)Blocks.field_222422_lK.func_176223_P().func_206870_a((Property)BarrelBlock.field_220092_a, (Comparable)Direction.func_239631_a_((Random)random)));
            }
            TileEntity container = world.func_175625_s(pos);
            if (container instanceof LockableLootTileEntity) {
                ((LockableLootTileEntity)container).func_189404_a(LootTables.CAMPSITE_CHEST, random.nextLong());
            }
        }
    }

    public void generateCraftingStation(ISeedReader world, BlockPos pos, Random random) {
        BlockState state = CRAFTING_STATION_PROVIDER.func_225574_a_(random, pos);
        this.func_230367_a_((IWorldWriter)world, pos, state);
        if (random.nextBoolean() && world.func_175623_d(pos.func_177984_a())) {
            this.generateDecoration(world, pos.func_177984_a(), random);
        }
    }

    public void generateDecoration(ISeedReader world, BlockPos pos, Random random) {
        if (random.nextInt(3) == 0) {
            this.func_230367_a_((IWorldWriter)world, pos, DECORATION_PROVIDER.func_225574_a_(random, pos));
        } else {
            this.func_230367_a_((IWorldWriter)world, pos, ((Block)BlockTags.field_200032_i.func_205596_a(random)).func_176223_P());
        }
    }

    public void generateOreVein(ISeedReader world, BlockPos pos, Random random) {
        BlockState ore = ORE_PROVIDER.func_225574_a_(random, pos);
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        positions.add(pos);
        for (int i = 4 + random.nextInt(12); i > 0; --i) {
            pos = (BlockPos)positions.remove(0);
            this.func_230367_a_((IWorldWriter)world, pos, ore);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (!world.func_180495_p(pos.func_177972_a(direction)).func_185904_a().func_76230_c() || world.func_180495_p(pos.func_177972_a(direction).func_177984_a()).func_185904_a().func_76230_c()) continue;
                positions.add(pos.func_177972_a(direction));
            }
            if (positions.size() != 0) continue;
            return;
        }
    }
}

