/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.base;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAtumSlab
extends Block {
    public static final PropertyEnum<Type> TYPE = PropertyEnum.func_177709_a((String)"type", Type.class);
    private static final AxisAlignedBB AABB_SLAB_BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    private static final AxisAlignedBB AABB_SLAB_TOP = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);

    public BlockAtumSlab(Material material) {
        this(material, material.func_151565_r());
    }

    public BlockAtumSlab(Material material, MapColor color) {
        super(material, color);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)Type.BOTTOM)));
        this.func_149713_g(255);
        this.field_149783_u = true;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    protected boolean func_149700_E() {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((Type)((Object)state.func_177229_b(TYPE))) {
            case DOUBLE: {
                return field_185505_j;
            }
            case TOP: {
                return AABB_SLAB_TOP;
            }
        }
        return AABB_SLAB_BOTTOM;
    }

    public boolean func_185481_k(IBlockState state) {
        return state.func_177229_b(TYPE) == Type.DOUBLE || state.func_177229_b(TYPE) == Type.TOP;
    }

    public boolean func_149662_c(IBlockState state) {
        return state.func_177229_b(TYPE) == Type.DOUBLE;
    }

    public boolean func_149686_d(IBlockState state) {
        return state.func_177229_b(TYPE) == Type.DOUBLE;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        Type type = (Type)((Object)state.func_177229_b(TYPE));
        if (type == Type.DOUBLE) {
            return BlockFaceShape.SOLID;
        }
        if (face == EnumFacing.UP && type == Type.TOP) {
            return BlockFaceShape.SOLID;
        }
        return face == EnumFacing.DOWN && type == Type.BOTTOM ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(IBlockState state, IBlockAccess source, @Nonnull BlockPos pos) {
        int i = source.func_175626_b(pos, state.getLightValue(source, pos));
        if (i == 0 && state.func_177230_c() instanceof BlockAtumSlab) {
            pos = pos.func_177977_b();
            state = source.func_180495_p(pos);
            return source.func_175626_b(pos, state.getLightValue(source, pos));
        }
        return super.func_185484_c(state, source, pos);
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (ForgeModContainer.disableStairSlabCulling) {
            return super.doesSideBlockRendering(state, world, pos, face);
        }
        if (state.func_185914_p()) {
            return true;
        }
        Type type = (Type)((Object)state.func_177229_b(TYPE));
        return type == Type.TOP && face == EnumFacing.UP || type == Type.BOTTOM && face == EnumFacing.DOWN;
    }

    @Nonnull
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(TYPE, (Comparable)((Object)Type.BOTTOM));
        if (state.func_177229_b(TYPE) == Type.DOUBLE) {
            return state.func_177226_a(TYPE, (Comparable)((Object)Type.DOUBLE));
        }
        return facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? state : state.func_177226_a(TYPE, (Comparable)((Object)Type.TOP));
    }

    public int quantityDropped(IBlockState state, int fortune, @Nonnull Random random) {
        return state.func_177229_b(TYPE) == Type.DOUBLE ? 2 : 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, EnumFacing side) {
        if (side != EnumFacing.UP && side != EnumFacing.DOWN && !super.func_176225_a(state, blockAccess, pos, side)) {
            return false;
        }
        return super.func_176225_a(state, blockAccess, pos, side);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)Type.byOrdinal(meta & 7)));
        if (state.func_177229_b(TYPE) != Type.DOUBLE) {
            state = state.func_177226_a(TYPE, (Comparable)((Object)((meta & 8) == 0 ? Type.BOTTOM : Type.TOP)));
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((Type)((Object)state.func_177229_b(TYPE))).ordinal();
        if (state.func_177229_b(TYPE) != Type.DOUBLE && state.func_177229_b(TYPE) == Type.TOP) {
            i |= 8;
        }
        return i;
    }

    public static enum Type implements IStringSerializable
    {
        TOP("top"),
        BOTTOM("bottom"),
        DOUBLE("double");

        private static final Type[] LENGTH_LOOKUP;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public static Type byOrdinal(int length) {
            if (length < 0 || length >= LENGTH_LOOKUP.length) {
                length = 0;
            }
            return LENGTH_LOOKUP[length];
        }

        public String toString() {
            return this.name;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        static {
            LENGTH_LOOKUP = new Type[Type.values().length];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                Type.LENGTH_LOOKUP[type.ordinal()] = type = typeArray[i];
            }
        }
    }
}

