/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.machines.tileentity;

import com.teammetallurgy.atum.api.recipe.RecipeHandlers;
import com.teammetallurgy.atum.api.recipe.kiln.IKilnRecipe;
import com.teammetallurgy.atum.blocks.machines.BlockKiln;
import com.teammetallurgy.atum.blocks.machines.tileentity.TileEntityKilnBase;
import com.teammetallurgy.atum.init.AtumBlocks;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemCoal;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityKiln
extends TileEntityKilnBase
implements ITickable {
    private int burnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private int totalCookTime;

    public void func_73660_a() {
        if (!this.isPrimary()) {
            return;
        }
        boolean isBurning = this.isBurning();
        boolean markDirty = false;
        if (this.isBurning()) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack fuelStack = (ItemStack)this.inventory.get(4);
            if (this.isBurning() || !fuelStack.func_190926_b() && !this.getInputs().isEmpty()) {
                int i;
                boolean canSmeltAny = false;
                for (i = 0; i <= 4; ++i) {
                    canSmeltAny |= this.canSmelt(i, 5, 8) != -1;
                }
                if (!this.isBurning() && canSmeltAny) {
                    this.currentItemBurnTime = this.burnTime = TileEntityFurnace.func_145952_a((ItemStack)fuelStack);
                    if (this.isBurning()) {
                        markDirty = true;
                        if (!fuelStack.func_190926_b()) {
                            Item fuelItemCached = fuelStack.func_77973_b();
                            fuelStack.func_190918_g(1);
                            if (fuelStack.func_190926_b()) {
                                ItemStack containerStack = fuelItemCached.getContainerItem(fuelStack);
                                this.inventory.set(4, (Object)containerStack);
                            }
                        }
                    }
                }
                if (this.isBurning() && canSmeltAny) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = 0;
                        if (!this.isInputEmpty()) {
                            this.totalCookTime = this.getCookTime();
                        }
                        for (i = 0; i <= 4; ++i) {
                            this.smeltItem(i, 5, 8);
                        }
                        markDirty = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0 || this.isInputEmpty()) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (isBurning != this.isBurning()) {
                IBlockState secondaryState;
                markDirty = true;
                this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockKiln.IS_BURNING, (Comparable)Boolean.valueOf(this.isBurning())));
                BlockPos secondaryKilnPos = BlockKiln.getSecondaryKilnFromPrimary(this.field_145850_b, this.field_174879_c);
                if (secondaryKilnPos != null && (secondaryState = this.field_145850_b.func_180495_p(secondaryKilnPos)).func_177230_c() == AtumBlocks.KILN) {
                    this.field_145850_b.func_175656_a(secondaryKilnPos, secondaryState.func_177226_a((IProperty)BlockKiln.IS_BURNING, (Comparable)Boolean.valueOf(this.isBurning())));
                }
            }
        }
        if (markDirty) {
            this.func_70296_d();
        }
    }

    private boolean isInputEmpty() {
        for (int i = 0; i <= 4; ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (!this.isPrimary()) {
            TileEntityKilnBase primary = this.getPrimary();
            if (primary != null) {
                primary.func_70299_a(index, stack);
            }
            return;
        }
        ItemStack slotStack = (ItemStack)this.inventory.get(index);
        boolean isValid = !stack.func_190926_b() && stack.func_77969_a(slotStack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)slotStack);
        this.func_184281_d(null);
        this.func_190576_q().set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index <= 3 && !isValid) {
            this.totalCookTime = this.getCookTime();
            this.func_70296_d();
        }
    }

    public boolean isBurning() {
        TileEntityKilnBase primary;
        if (!this.isPrimary() && (primary = this.getPrimary()) != null) {
            return ((TileEntityKiln)primary).isBurning();
        }
        return this.burnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    private int getCookTime() {
        return 200;
    }

    private int canSmelt(int inputSlot, int outputSlotStart, int outputSlotEnd) {
        if (((ItemStack)this.inventory.get(inputSlot)).func_190926_b()) {
            return -1;
        }
        ItemStack result = this.getSmeltingResult((ItemStack)this.inventory.get(inputSlot));
        if (result.func_190926_b()) {
            return -1;
        }
        for (int outputSlot = outputSlotStart; outputSlot <= outputSlotEnd; ++outputSlot) {
            ItemStack output = (ItemStack)this.inventory.get(outputSlot);
            if (output.func_190926_b()) {
                return outputSlot;
            }
            if (!output.func_77969_a(result)) continue;
            if (output.func_190916_E() + result.func_190916_E() <= this.func_70297_j_() && output.func_190916_E() + result.func_190916_E() <= output.func_77976_d()) {
                return outputSlot;
            }
            if (output.func_190916_E() + result.func_190916_E() > result.func_77976_d()) continue;
            return outputSlot;
        }
        return -1;
    }

    private void smeltItem(int inputSlot, int outputSlotStart, int outputSlotEnd) {
        int outputSlot = this.canSmelt(inputSlot, outputSlotStart, outputSlotEnd);
        if (outputSlot != -1) {
            ItemStack input = (ItemStack)this.inventory.get(inputSlot);
            ItemStack result = this.getSmeltingResult(input);
            ItemStack output = (ItemStack)this.inventory.get(outputSlot);
            if (output.func_190926_b()) {
                this.inventory.set(outputSlot, (Object)result.func_77946_l());
            } else if (output.func_77973_b() == result.func_77973_b()) {
                output.func_190917_f(result.func_190916_E());
            }
            input.func_190918_g(1);
        }
    }

    @Nonnull
    private ItemStack getSmeltingResult(@Nonnull ItemStack input) {
        for (IKilnRecipe kilnRecipe : RecipeHandlers.kilnRecipes) {
            if (!this.compareItemStacks((ItemStack)kilnRecipe.getInput().get(0), input)) continue;
            return kilnRecipe.getOutput();
        }
        return ItemStack.field_190927_a;
    }

    private boolean compareItemStacks(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack1.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    private List<ItemStack> getInputs() {
        return Arrays.asList((ItemStack)this.inventory.get(0), (ItemStack)this.inventory.get(1), (ItemStack)this.inventory.get(2), (ItemStack)this.inventory.get(3));
    }

    public static boolean canKilnNotSmelt(@Nonnull ItemStack stack) {
        Item item = stack.func_77973_b();
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        String oreName = "";
        for (int oreId : OreDictionary.getOreIDs((ItemStack)stack)) {
            oreName = OreDictionary.getOreName((int)oreId).toLowerCase(Locale.ENGLISH);
        }
        return RecipeHandlers.kilnBlacklist.contains(item.getRegistryName()) || RecipeHandlers.kilnBlacklist.contains(block.getRegistryName()) || item instanceof ItemFood || block instanceof BlockOre || item instanceof ItemCoal || oreName.contains("plank") || oreName.contains("log") || oreName.contains("stick") || oreName.contains("torch") || oreName.contains("plant") || oreName.contains("sugarcane") || oreName.contains("ore") || oreName.contains("ingot") && !oreName.contains("ingotbrick") || oreName.contains("nugget") || oreName.contains("gem") || oreName.contains("dust") || oreName.contains("crushed") || oreName.contains("dye") || oreName.contains("slime") || oreName.contains("leather") || oreName.contains("rubber") || block instanceof BlockSponge;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.burnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.burnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.burnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("CookTimeTotal");
        this.currentItemBurnTime = TileEntityFurnace.func_145952_a((ItemStack)((ItemStack)this.inventory.get(4)));
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", (int)((short)this.burnTime));
        compound.func_74768_a("CookTime", (int)((short)this.cookTime));
        compound.func_74768_a("CookTimeTotal", (int)((short)this.totalCookTime));
        return compound;
    }
}

