/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.stone.limestone;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRaStone
extends BlockBreakable {
    private static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);

    public BlockRaStone() {
        super(Material.field_151576_e, false, MapColor.field_151645_D);
        this.func_149675_a(true);
        this.func_149711_c(0.5f);
        this.func_149713_g(3);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    @Nonnull
    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.NORMAL;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if ((rand.nextInt(3) == 0 || this.countNeighbors(world, pos) < 4) && world.func_175671_l(pos) > 11 - (Integer)state.func_177229_b((IProperty)AGE) - state.func_185891_c()) {
            this.startToDisappear(world, pos, state, rand, true);
        } else {
            world.func_175684_a(pos, (Block)this, MathHelper.func_76136_a((Random)rand, (int)20, (int)40));
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        int i;
        if (block == this && (i = this.countNeighbors(world, pos)) < 2) {
            this.turnIntoLava(world, pos);
        }
    }

    private int countNeighbors(World worldIn, BlockPos pos) {
        int i = 0;
        for (EnumFacing facing : EnumFacing.values()) {
            if (worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c() != this || ++i < 4) continue;
            return i;
        }
        return i;
    }

    private void startToDisappear(World world, BlockPos pos, IBlockState state, Random rand, boolean meltNeighbors) {
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        if (i < 3) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            world.func_175684_a(pos, (Block)this, MathHelper.func_76136_a((Random)rand, (int)20, (int)40));
        } else {
            this.turnIntoLava(world, pos);
            if (meltNeighbors) {
                for (EnumFacing facing : EnumFacing.values()) {
                    BlockPos posOffset = pos.func_177972_a(facing);
                    IBlockState stateOffset = world.func_180495_p(posOffset);
                    if (stateOffset.func_177230_c() != this) continue;
                    this.startToDisappear(world, posOffset, stateOffset, rand, false);
                }
            }
        }
    }

    private void turnIntoLava(World world, BlockPos pos) {
        this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
        world.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
        world.func_190524_a(pos, (Block)Blocks.field_150353_l, pos);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    protected ItemStack func_180643_i(@Nonnull IBlockState state) {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)meta, (int)0, (int)3)));
    }
}

