/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.undead;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.tileentity.TileEntitySarcophagus;
import com.teammetallurgy.atum.entity.undead.EntityMummy;
import com.teammetallurgy.atum.entity.undead.EntityUndeadBase;
import com.teammetallurgy.atum.items.artifacts.horus.ItemHorusAscension;
import com.teammetallurgy.atum.items.tools.ItemScepter;
import com.teammetallurgy.atum.utils.AtumUtils;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityPharaoh
extends EntityUndeadBase {
    private static String[] prefixArray = new String[]{"Ama", "Ata", "Ato", "Bak", "Cal", "Djet", "Eje", "For", "Gol", "Gut", "Hop", "Hor", "Huni", "Iam", "Jor", "Kal", "Khas", "Khor", "Lat", "Mal", "Not", "Oap", "Pra", "Qo", "Ras", "Shas", "Thoth", "Tui", "Uld", "Ver", "Wot", "Xo", "Yat", "Zyt", "Khep"};
    private static String[] suffixArray = new String[]{"Ahat", "Amesh", "Amon", "Anut", "Baroom", "Chanta", "Erant", "Funam", "Daresh", "Djer", "Hotesh", "Khaden", "Kron", "Gorkum", "Ialenter", "Ma'at", "Narmer", "Radeem", "Jaloom", "Lepsha", "Quor", "Oleshet", "Peput", "Talat", "Ulam", "Veresh", "Ranesh", "Snef", "Wollolo", "Hathor", "Intef", "Neferk", "Khatne", "Tepy", "Moret"};
    private static String[] numeralArray = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV"};
    private static final DataParameter<Integer> PREFIX = EntityDataManager.func_187226_a(EntityPharaoh.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SUFFIX = EntityDataManager.func_187226_a(EntityPharaoh.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> NUMERAL = EntityDataManager.func_187226_a(EntityPharaoh.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<BlockPos>> SARCOPHAGUS_POS = EntityDataManager.func_187226_a(EntityPharaoh.class, (DataSerializer)DataSerializers.field_187201_k);
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.YELLOW, BossInfo.Overlay.NOTCHED_10).func_186743_c(true);
    private int stage;
    private int suffixID = 0;
    private int prefixID = 0;
    private int numID = 0;
    private int regenTime = 0;
    private int berserkTimer;
    private float berserkDamage;
    private String texturePath;

    public EntityPharaoh(World world) {
        super(world);
        this.func_70606_j(this.func_110138_aP());
        this.field_70178_ae = true;
        this.field_70728_aV = 250;
        this.stage = 0;
        this.func_98053_h(false);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    protected boolean hasSkinVariants() {
        return true;
    }

    @Override
    protected int getVariantAmount() {
        return God.values().length - 1;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
    }

    @Override
    protected void func_175456_n() {
        super.func_175456_n();
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(36.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PREFIX, (Object)0);
        this.field_70180_af.func_187214_a(SUFFIX, (Object)0);
        this.field_70180_af.func_187214_a(NUMERAL, (Object)0);
        this.field_70180_af.func_187214_a(SARCOPHAGUS_POS, (Object)Optional.absent());
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191268_hm;
    }

    @Override
    protected boolean shouldBurnInDay() {
        return false;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        ItemScepter scepter = ItemScepter.getScepter(God.getGod(this.getVariant()));
        if (scepter != null) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)scepter));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTexture() {
        if (this.texturePath == null) {
            this.texturePath = new ResourceLocation("atum", "textures/entity/pharaoh_" + (Object)((Object)God.getGod(this.getVariant()))) + ".png";
        }
        return this.texturePath;
    }

    @Override
    protected void setVariant(int variant) {
        super.setVariant(variant);
        this.texturePath = null;
    }

    @Override
    protected void setVariantAbilities(DifficultyInstance difficulty, int variant) {
        super.setVariantAbilities(difficulty, variant);
        this.prefixID = this.field_70146_Z.nextInt(prefixArray.length);
        this.suffixID = this.field_70146_Z.nextInt(suffixArray.length);
        this.numID = this.field_70146_Z.nextInt(numeralArray.length);
        this.setPharaohName(this.prefixID, this.suffixID, this.numID);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
    }

    public boolean func_98052_bS() {
        return false;
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
    }

    private BlockPos getSarcophagusPos() {
        return (BlockPos)((Optional)this.field_70180_af.func_187225_a(SARCOPHAGUS_POS)).orNull();
    }

    public void setSarcophagusPos(BlockPos pos) {
        this.field_70180_af.func_187227_b(SARCOPHAGUS_POS, (Object)Optional.fromNullable((Object)pos));
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected void func_70623_bb() {
    }

    public void func_70645_a(@Nonnull DamageSource source) {
        BlockPos sarcophagusPos;
        if (!this.field_70170_p.field_72995_K && (sarcophagusPos = this.getSarcophagusPos()) != null) {
            TileEntity tileEntity = this.field_70170_p.func_175625_s(sarcophagusPos);
            if (tileEntity instanceof TileEntitySarcophagus) {
                ((TileEntitySarcophagus)tileEntity).setOpenable();
                for (EnumFacing horizontal : EnumFacing.field_176754_o) {
                    TileEntity tileEntityOffset = this.field_70170_p.func_175625_s(sarcophagusPos.func_177972_a(horizontal));
                    if (!(tileEntityOffset instanceof TileEntitySarcophagus)) continue;
                    ((TileEntitySarcophagus)tileEntityOffset).setOpenable();
                }
            } else {
                Atum.LOG.error("Unable to find sarcophagus coordinates for " + this.func_70005_c_() + " on " + sarcophagusPos);
            }
        }
        if (source.field_76373_n.equals("player")) {
            EntityPlayer slayer = (EntityPlayer)source.func_76346_g();
            if (!this.field_70170_p.field_72995_K && slayer != null) {
                List players = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
                for (EntityPlayer player : players) {
                    player.func_145747_a((ITextComponent)new TextComponentString(God.getGod(this.getVariant()).getColor() + this.func_70005_c_() + " " + AtumUtils.format("chat.atum.killPharaoh") + " " + slayer.func_146103_bH().getName()));
                }
            }
        }
        super.func_70645_a(source);
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Nonnull
    public String func_70005_c_() {
        int p = (Integer)this.field_70180_af.func_187225_a(PREFIX);
        int s = (Integer)this.field_70180_af.func_187225_a(SUFFIX);
        int n = (Integer)this.field_70180_af.func_187225_a(NUMERAL);
        return "Pharaoh " + AtumUtils.format("entity.atum.pharaoh." + prefixArray[p]) + AtumUtils.format("entity.atum.pharaoh." + suffixArray[s].toLowerCase(Locale.ENGLISH)) + " " + numeralArray[n];
    }

    public void func_70653_a(@Nonnull Entity entity, float strength, double xRatio, double zRatio) {
        if (God.getGod(this.getVariant()) != God.PTAH) {
            super.func_70653_a(entity, strength *= 0.2f, xRatio, zRatio);
        }
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            if (this.func_110143_aJ() < this.func_110138_aP() * 0.75f && this.stage == 0) {
                ++this.stage;
                this.spawnGuards(this.func_180425_c());
            } else if (this.stage == 1 && this.func_110143_aJ() < this.func_110138_aP() * 0.5f) {
                ++this.stage;
                this.spawnGuards(this.func_180425_c());
            } else if (this.stage == 2 && this.func_110143_aJ() < this.func_110138_aP() * 0.25f) {
                ++this.stage;
                this.spawnGuards(this.func_180425_c());
            }
            return true;
        }
        return false;
    }

    public boolean func_70652_k(Entity entity) {
        if (!super.func_70652_k(entity)) {
            return false;
        }
        if (entity instanceof EntityLivingBase && !this.field_70170_p.field_72995_K) {
            EntityLivingBase entityLiving = (EntityLivingBase)entity;
            switch (God.getGod(this.getVariant())) {
                case ANPUT: {
                    entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 80, 1));
                    break;
                }
                case ANUBIS: {
                    entityLiving.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 60, 1));
                    break;
                }
                case GEB: {
                    entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 60, 1));
                    break;
                }
                case HORUS: {
                    entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 60, 1));
                    break;
                }
                case NUIT: {
                    entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 60));
                    break;
                }
                case RA: {
                    entityLiving.func_70015_d(4);
                    break;
                }
                case SETH: {
                    entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100, 1));
                    break;
                }
                case SHU: {
                    ItemHorusAscension.knockUp(entityLiving, (EntityLivingBase)this, this.field_70146_Z);
                    break;
                }
                case TEFNUT: {
                    entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 60));
                    break;
                }
            }
        }
        return true;
    }

    @SubscribeEvent
    public void onBerserk(LivingHurtEvent event) {
        if (event.getSource().func_76346_g() == this && God.getGod(this.getVariant()) == God.MONTU) {
            if (this.berserkTimer == 0) {
                event.setAmount(event.getAmount());
                this.berserkDamage = event.getAmount() / 10.0f + event.getAmount();
                this.berserkTimer = 80;
            } else {
                this.berserkDamage += event.getAmount() / 10.0f;
                event.setAmount(this.berserkDamage);
                this.berserkTimer = 80;
            }
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBossInfo(this.getVariant());
        }
        if (this.field_70170_p.func_175659_aa().func_151525_a() == 0) {
            TileEntity te;
            if (this.getSarcophagusPos() != null && (te = this.field_70170_p.func_175625_s(this.getSarcophagusPos())) instanceof TileEntitySarcophagus) {
                ((TileEntitySarcophagus)te).hasSpawned = false;
            }
            this.func_70106_y();
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    @Override
    public void func_70636_d() {
        if (this.regenTime++ > 60) {
            this.regenTime = 0;
            this.func_70691_i(God.getGod(this.getVariant()) == God.ISIS ? 2.0f : 1.0f);
        }
        if (God.getGod(this.getVariant()) == God.MONTU && this.berserkTimer > 1) {
            --this.berserkTimer;
        }
        if (this.berserkTimer == 1) {
            this.berserkDamage = 0.0f;
            this.berserkTimer = 0;
        }
        super.func_70636_d();
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("prefix", this.prefixID);
        compound.func_74768_a("suffix", this.suffixID);
        compound.func_74768_a("numeral", this.numID);
        BlockPos sarcophagusPos = this.getSarcophagusPos();
        if (sarcophagusPos != null) {
            compound.func_74768_a("sarcophagus_x", sarcophagusPos.func_177958_n());
            compound.func_74768_a("sarcophagus_y", sarcophagusPos.func_177956_o());
            compound.func_74768_a("sarcophagus_z", sarcophagusPos.func_177952_p());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.prefixID = compound.func_74762_e("prefix");
        this.suffixID = compound.func_74762_e("suffix");
        this.numID = compound.func_74762_e("numeral");
        if (compound.func_74764_b("sarcophagus_x")) {
            int x = compound.func_74762_e("sarcophagus_x");
            int y = compound.func_74762_e("sarcophagus_y");
            int z = compound.func_74762_e("sarcophagus_z");
            this.field_70180_af.func_187227_b(SARCOPHAGUS_POS, (Object)Optional.of((Object)new BlockPos(x, y, z)));
        } else {
            this.field_70180_af.func_187227_b(SARCOPHAGUS_POS, (Object)Optional.absent());
        }
        this.setPharaohName(compound.func_74762_e("prefix"), compound.func_74762_e("suffix"), compound.func_74762_e("numeral"));
    }

    private void setPharaohName(int prefix, int suffix, int numeral) {
        this.field_70180_af.func_187227_b(PREFIX, (Object)prefix);
        this.field_70180_af.func_187227_b(SUFFIX, (Object)suffix);
        this.field_70180_af.func_187227_b(NUMERAL, (Object)numeral);
    }

    public void spawnGuards(BlockPos pos) {
        EnumFacing facing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(this.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        this.trySpawnMummy(pos, facing);
        this.trySpawnMummy(pos, facing.func_176746_e().func_176746_e());
    }

    private void trySpawnMummy(BlockPos pos, EnumFacing facing) {
        BlockPos base = pos.func_177967_a(facing, 1);
        if (!this.field_70170_p.func_175665_u(base) && !this.field_70170_p.func_175665_u(base.func_177972_a(EnumFacing.UP))) {
            EntityMummy entityMummy = new EntityMummy(this.field_70170_p);
            entityMummy.func_180482_a(this.field_70170_p.func_175649_E(base), null);
            entityMummy.func_70012_b(base.func_177958_n(), base.func_177956_o(), base.func_177952_p(), this.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (!this.field_70170_p.field_72995_K) {
                AnvilChunkLoader.func_186052_a((Entity)entityMummy, (World)this.field_70170_p);
            }
            entityMummy.func_70656_aK();
            return;
        }
        for (EnumFacing offset : EnumFacing.field_176754_o) {
            BlockPos new_pos;
            if (offset == facing.func_176734_d() || this.field_70170_p.func_175665_u(new_pos = base.func_177972_a(offset)) || this.field_70170_p.func_175665_u(new_pos.func_177972_a(EnumFacing.UP))) continue;
            EntityMummy entityMummy = new EntityMummy(this.field_70170_p);
            entityMummy.func_180482_a(this.field_70170_p.func_175649_E(new_pos), null);
            entityMummy.func_70012_b(new_pos.func_177958_n(), new_pos.func_177956_o(), new_pos.func_177952_p(), this.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (!this.field_70170_p.field_72995_K) {
                AnvilChunkLoader.func_186052_a((Entity)entityMummy, (World)this.field_70170_p);
            }
            entityMummy.func_70656_aK();
            return;
        }
    }

    private void setBossInfo(int variant) {
        this.bossInfo.func_186739_a(this.func_145748_c_().func_150255_a(new Style().func_150238_a(God.getGod(variant).getColor())));
    }

    public static enum God {
        ANPUT("anput", TextFormatting.BLACK),
        ANUBIS("anubis", TextFormatting.DARK_PURPLE),
        ATUM("atum", TextFormatting.DARK_AQUA),
        GEB("geb", TextFormatting.GOLD),
        HORUS("horus", TextFormatting.AQUA),
        ISIS("isis", TextFormatting.LIGHT_PURPLE),
        MONTU("montu", TextFormatting.DARK_RED),
        NUIT("nuit", TextFormatting.GRAY),
        PTAH("ptah", TextFormatting.YELLOW),
        RA("ra", TextFormatting.DARK_RED),
        SETH("seth", TextFormatting.GREEN),
        SHU("shu", TextFormatting.BLUE),
        TEFNUT("tefnut", TextFormatting.DARK_BLUE);

        static Map<Integer, God> MAP;
        private final String name;
        private final TextFormatting color;

        private God(String name, TextFormatting color) {
            this.name = name;
            this.color = color;
        }

        public String getName() {
            return this.name;
        }

        public TextFormatting getColor() {
            return this.color;
        }

        public static God getGod(int godType) {
            God god;
            if (MAP == null) {
                MAP = Maps.newHashMap();
                for (God g : God.values()) {
                    MAP.put(g.ordinal(), g);
                }
            }
            return (god = MAP.get(godType)) == null ? ANPUT : god;
        }
    }
}

