/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world;

import com.teammetallurgy.atum.blocks.BlockSandLayers;
import com.teammetallurgy.atum.init.AtumBiomes;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.utils.AtumConfig;
import com.teammetallurgy.atum.world.biome.base.AtumBiome;
import com.teammetallurgy.atum.world.gen.feature.WorldGenAtumDungeons;
import com.teammetallurgy.atum.world.gen.feature.WorldGenLava;
import com.teammetallurgy.atum.world.gen.structure.girafitomb.GirafiTombPieces;
import com.teammetallurgy.atum.world.gen.structure.girafitomb.MapGenGirafiTomb;
import com.teammetallurgy.atum.world.gen.structure.lighthouse.LighthousePieces;
import com.teammetallurgy.atum.world.gen.structure.lighthouse.MapGenLighthouse;
import com.teammetallurgy.atum.world.gen.structure.mineshaft.MapGenAtumMineshaft;
import com.teammetallurgy.atum.world.gen.structure.pyramid.MapGenPyramid;
import com.teammetallurgy.atum.world.gen.structure.pyramid.PyramidPieces;
import com.teammetallurgy.atum.world.gen.structure.ruins.MapGenRuin;
import com.teammetallurgy.atum.world.gen.structure.ruins.RuinPieces;
import com.teammetallurgy.atum.world.gen.structure.tomb.MapGenTomb;
import com.teammetallurgy.atum.world.gen.structure.tomb.TombPieces;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class ChunkGeneratorAtum
implements IChunkGenerator {
    private static final IBlockState LIMESTONE = AtumBlocks.LIMESTONE.func_176223_P();
    private final Random rand;
    private NoiseGeneratorOctaves minLimitPerlinNoise;
    private NoiseGeneratorOctaves maxLimitPerlinNoise;
    private NoiseGeneratorOctaves mainPerlinNoise;
    private NoiseGeneratorPerlin surfaceNoise;
    private NoiseGeneratorOctaves scaleNoise;
    private NoiseGeneratorOctaves depthNoise;
    private NoiseGeneratorOctaves forestNoise;
    private final World world;
    private final boolean mapFeaturesEnabled;
    private final double[] heightMap;
    private final float[] biomeWeights;
    private ChunkGeneratorSettings settings;
    private double[] depthBuffer = new double[256];
    private MapGenBase caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)new MapGenCaves(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
    private MapGenAtumMineshaft mineshaftGenerator = (MapGenAtumMineshaft)TerrainGen.getModdedMapGen((MapGenBase)new MapGenAtumMineshaft(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
    private MapGenBase ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)new MapGenRavine(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
    public MapGenPyramid pyramidGenerator = new MapGenPyramid(this);
    private MapGenRuin ruinGenerator = new MapGenRuin(this);
    private MapGenTomb tombGenerator = new MapGenTomb(this);
    private MapGenGirafiTomb girafiTomb = new MapGenGirafiTomb(this);
    private MapGenLighthouse lighthouse = new MapGenLighthouse(this);
    private Biome[] biomesForGeneration;
    private double[] mainNoiseRegion;
    private double[] minLimitRegion;
    private double[] maxLimitRegion;
    private double[] depthRegion;

    public ChunkGeneratorAtum(World world, long seed, boolean mapFeaturesEnabled, String generatorOptions) {
        this.world = world;
        this.mapFeaturesEnabled = mapFeaturesEnabled;
        this.rand = new Random(seed);
        this.minLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.maxLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.mainPerlinNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.surfaceNoise = new NoiseGeneratorPerlin(this.rand, 4);
        this.scaleNoise = new NoiseGeneratorOctaves(this.rand, 10);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.forestNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.heightMap = new double[825];
        this.biomeWeights = new float[25];
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                this.biomeWeights[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
        if (generatorOptions != null) {
            this.settings = ChunkGeneratorSettings.Factory.func_177865_a((String)generatorOptions).func_177864_b();
        }
        world.func_181544_b(63);
        InitNoiseGensEvent.ContextOverworld ctx = new InitNoiseGensEvent.ContextOverworld(this.minLimitPerlinNoise, this.maxLimitPerlinNoise, this.mainPerlinNoise, this.surfaceNoise, this.scaleNoise, this.depthNoise, this.forestNoise);
        ctx = (InitNoiseGensEvent.ContextOverworld)TerrainGen.getModdedNoiseGenerators((World)world, (Random)this.rand, (InitNoiseGensEvent.Context)ctx);
        this.minLimitPerlinNoise = ctx.getLPerlin1();
        this.maxLimitPerlinNoise = ctx.getLPerlin2();
        this.mainPerlinNoise = ctx.getPerlin();
        this.surfaceNoise = ctx.getHeight();
        this.scaleNoise = ctx.getScale();
        this.depthNoise = ctx.getDepth();
        this.forestNoise = ctx.getForest();
    }

    public void setBlocksInChunk(int x, int z, ChunkPrimer primer) {
        this.biomesForGeneration = this.world.func_72959_q().func_76937_a(this.biomesForGeneration, x * 4 - 2, z * 4 - 2, 10, 10);
        this.generateHeightmap(x * 4, 0, z * 4);
        for (int i = 0; i < 4; ++i) {
            int j = i * 5;
            int k = (i + 1) * 5;
            for (int l = 0; l < 4; ++l) {
                int i1 = (j + l) * 33;
                int j1 = (j + l + 1) * 33;
                int k1 = (k + l) * 33;
                int l1 = (k + l + 1) * 33;
                for (int i2 = 0; i2 < 32; ++i2) {
                    double d0 = 0.125;
                    double d1 = this.heightMap[i1 + i2];
                    double d2 = this.heightMap[j1 + i2];
                    double d3 = this.heightMap[k1 + i2];
                    double d4 = this.heightMap[l1 + i2];
                    double d5 = (this.heightMap[i1 + i2 + 1] - d1) * d0;
                    double d6 = (this.heightMap[j1 + i2 + 1] - d2) * d0;
                    double d7 = (this.heightMap[k1 + i2 + 1] - d3) * d0;
                    double d8 = (this.heightMap[l1 + i2 + 1] - d4) * d0;
                    for (int j2 = 0; j2 < 8; ++j2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int k2 = 0; k2 < 4; ++k2) {
                            double d16 = (d11 - d10) * d9;
                            double lvt_45_1_ = d10 - d16;
                            for (int l2 = 0; l2 < 4; ++l2) {
                                double d;
                                lvt_45_1_ += d16;
                                if (!(d > 0.0)) continue;
                                primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, LIMESTONE);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private void replaceBiomeBlocks(int x, int z, ChunkPrimer primer, Biome[] biomes) {
        this.depthBuffer = this.surfaceNoise.func_151599_a(this.depthBuffer, (double)(x * 16), (double)(z * 16), 16, 16, 0.0625, 0.0625, 1.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biome = biomes[j + i * 16];
                biome.func_180622_a(this.world, this.rand, primer, x * 16 + i, z * 16 + j, this.depthBuffer[j + i * 16]);
            }
        }
    }

    @Nonnull
    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.setBlocksInChunk(x, z, chunkprimer);
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.replaceBiomeBlocks(x, z, chunkprimer, this.biomesForGeneration);
        if (this.settings.field_177839_r) {
            this.caveGenerator.func_186125_a(this.world, x, z, chunkprimer);
        }
        if (this.settings.field_177850_z) {
            this.ravineGenerator.func_186125_a(this.world, x, z, chunkprimer);
        }
        if (this.mapFeaturesEnabled) {
            if (this.settings.field_177829_w) {
                this.mineshaftGenerator.func_186125_a(this.world, x, z, chunkprimer);
            }
            if (AtumConfig.PYRAMID_ENABLED) {
                this.pyramidGenerator.func_186125_a(this.world, x, z, chunkprimer);
            }
            this.ruinGenerator.func_186125_a(this.world, x, z, chunkprimer);
            this.tombGenerator.func_186125_a(this.world, x, z, chunkprimer);
            this.girafiTomb.func_186125_a(this.world, x, z, chunkprimer);
            this.lighthouse.func_186125_a(this.world, x, z, chunkprimer);
        }
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)AtumBiome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void generateHeightmap(int x, int y, int z) {
        this.depthRegion = this.depthNoise.func_76305_a(this.depthRegion, x, z, 5, 5, (double)this.settings.field_177808_e, (double)this.settings.field_177803_f, (double)this.settings.field_177804_g);
        float f = this.settings.field_177811_a;
        float f1 = this.settings.field_177809_b;
        this.mainNoiseRegion = this.mainPerlinNoise.func_76304_a(this.mainNoiseRegion, x, y, z, 5, 33, 5, (double)(f / this.settings.field_177825_h), (double)(f1 / this.settings.field_177827_i), (double)(f / this.settings.field_177821_j));
        this.minLimitRegion = this.minLimitPerlinNoise.func_76304_a(this.minLimitRegion, x, y, z, 5, 33, 5, (double)f, (double)f1, (double)f);
        this.maxLimitRegion = this.maxLimitPerlinNoise.func_76304_a(this.maxLimitRegion, x, y, z, 5, 33, 5, (double)f, (double)f1, (double)f);
        int i = 0;
        int j = 0;
        for (int k = 0; k < 5; ++k) {
            for (int l = 0; l < 5; ++l) {
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                int i1 = 2;
                Biome biome = this.biomesForGeneration[k + 2 + (l + 2) * 10];
                for (int j1 = -2; j1 <= 2; ++j1) {
                    for (int k1 = -2; k1 <= 2; ++k1) {
                        Biome biome1 = this.biomesForGeneration[k + j1 + 2 + (l + k1 + 2) * 10];
                        float f5 = this.settings.field_177813_n + biome1.func_185355_j() * this.settings.field_177819_m;
                        float f6 = this.settings.field_177843_p + biome1.func_185360_m() * this.settings.field_177815_o;
                        float f7 = this.biomeWeights[j1 + 2 + (k1 + 2) * 5] / (f5 + 2.0f);
                        if (biome1.func_185355_j() > biome.func_185355_j()) {
                            f7 /= 2.0f;
                        }
                        f2 += f6 * f7;
                        f3 += f5 * f7;
                        f4 += f7;
                    }
                }
                f2 /= f4;
                f3 /= f4;
                f2 = f2 * 0.9f + 0.1f;
                f3 = (f3 * 4.0f - 1.0f) / 8.0f;
                double d7 = this.depthRegion[j] / 8000.0;
                if (d7 < 0.0) {
                    d7 = -d7 * 0.3;
                }
                if ((d7 = d7 * 3.0 - 2.0) < 0.0) {
                    if ((d7 /= 2.0) < -1.0) {
                        d7 = -1.0;
                    }
                    d7 /= 1.4;
                    d7 /= 2.0;
                } else {
                    if (d7 > 1.0) {
                        d7 = 1.0;
                    }
                    d7 /= 8.0;
                }
                ++j;
                double d8 = f3;
                double d9 = f2;
                d8 += d7 * 0.2;
                d8 = d8 * (double)this.settings.field_177823_k / 8.0;
                double d0 = (double)this.settings.field_177823_k + d8 * 4.0;
                for (int l1 = 0; l1 < 33; ++l1) {
                    double d1 = ((double)l1 - d0) * (double)this.settings.field_177817_l * 128.0 / 256.0 / d9;
                    if (d1 < 0.0) {
                        d1 *= 4.0;
                    }
                    double d2 = this.minLimitRegion[i] / (double)this.settings.field_177806_d;
                    double d3 = this.maxLimitRegion[i] / (double)this.settings.field_177810_c;
                    double d4 = (this.mainNoiseRegion[i] / 10.0 + 1.0) / 2.0;
                    double d5 = MathHelper.func_151238_b((double)d2, (double)d3, (double)d4) - d1;
                    if (l1 > 29) {
                        double d6 = (float)(l1 - 29) / 3.0f;
                        d5 = d5 * (1.0 - d6) + -10.0 * d6;
                    }
                    this.heightMap[i] = d5;
                    ++i;
                }
            }
        }
    }

    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * k + (long)z * l ^ this.world.func_72905_C());
        ChunkPos chunkpos = new ChunkPos(x, z);
        if (this.mapFeaturesEnabled) {
            if (this.settings.field_177829_w) {
                this.mineshaftGenerator.func_175794_a(this.world, this.rand, chunkpos);
            }
            if (AtumConfig.PYRAMID_ENABLED) {
                this.pyramidGenerator.func_175794_a(this.world, this.rand, chunkpos);
            }
            this.ruinGenerator.func_175794_a(this.world, this.rand, chunkpos);
            this.tombGenerator.func_175794_a(this.world, this.rand, chunkpos);
            this.girafiTomb.func_175794_a(this.world, this.rand, chunkpos);
            this.lighthouse.func_175794_a(this.world, this.rand, chunkpos);
        }
        if (this.rand.nextInt(this.settings.field_177777_D / 10) == 0 && this.settings.field_177783_C) {
            int i2 = this.rand.nextInt(16) + 8;
            int l2 = this.rand.nextInt(this.rand.nextInt(248) + 8);
            int k3 = this.rand.nextInt(16) + 8;
            if (l2 < this.world.func_181545_F() || this.rand.nextInt(this.settings.field_177777_D / 8) == 0) {
                new WorldGenLava((Block)Blocks.field_150353_l).func_180709_b(this.world, this.rand, blockpos.func_177982_a(i2, l2, k3));
            }
        }
        if (this.settings.field_177837_s) {
            for (int j2 = 0; j2 < this.settings.field_177835_t; ++j2) {
                int i3 = this.rand.nextInt(16) + 8;
                int l3 = this.rand.nextInt(256);
                int l1 = this.rand.nextInt(16) + 8;
                new WorldGenAtumDungeons().func_180709_b(this.world, this.rand, blockpos.func_177982_a(i3, l3, l1));
            }
        }
        biome.func_180624_a(this.world, this.rand, new BlockPos(i, 0, j));
        blockpos = blockpos.func_177982_a(8, 0, 8);
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.CUSTOM)) {
            for (int k2 = 0; k2 < 16; ++k2) {
                for (int j3 = 0; j3 < 16; ++j3) {
                    BlockPos blockpos1 = this.world.func_175725_q(blockpos.func_177982_a(k2, 0, j3));
                    if (!ChunkGeneratorAtum.canPlaceSandLayer(this.world, blockpos1, biome) || !this.world.func_175623_d(blockpos1)) continue;
                    for (EnumFacing facing : EnumFacing.field_176754_o) {
                        BlockPos posOffset = blockpos1.func_177972_a(facing);
                        if (!this.world.func_180495_p(posOffset).isSideSolid((IBlockAccess)this.world, posOffset, EnumFacing.UP)) continue;
                        int layers = MathHelper.func_76136_a((Random)this.rand, (int)1, (int)3);
                        this.world.func_180501_a(blockpos1, AtumBlocks.SAND_LAYERED.func_176223_P().func_177226_a((IProperty)BlockSandLayers.LAYERS, (Comparable)Integer.valueOf(layers)), 2);
                    }
                }
            }
        }
        BlockFalling.field_149832_M = false;
    }

    static boolean canPlaceSandLayer(World world, BlockPos pos, Biome biome) {
        IBlockState stateDown = world.func_180495_p(pos.func_177977_b());
        return biome != AtumBiomes.OASIS && stateDown.func_177230_c() != AtumBlocks.LIMESTONE_CRACKED && stateDown.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) && !(stateDown.func_177230_c() instanceof BlockSandLayers) && !(world.func_180495_p(pos).func_177230_c() instanceof BlockSandLayers);
    }

    public boolean func_185933_a(@Nonnull Chunk chunk, int x, int z) {
        return false;
    }

    @Nonnull
    public List<Biome.SpawnListEntry> func_177458_a(@Nonnull EnumCreatureType creatureType, @Nonnull BlockPos pos) {
        if (this.lighthouse.func_175796_a(this.world, pos) && creatureType == EnumCreatureType.AMBIENT) {
            return this.lighthouse.getNaturalSpawns();
        }
        return this.world.func_180494_b(pos).func_76747_a(creatureType);
    }

    public boolean func_193414_a(@Nonnull World world, @Nonnull String structureName, @Nonnull BlockPos pos) {
        if (!this.mapFeaturesEnabled) {
            return false;
        }
        if (String.valueOf(MapGenAtumMineshaft.MINESHAFT).equals(structureName) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_175795_b(pos);
        }
        if (String.valueOf(PyramidPieces.PYRAMID).equals(structureName) && this.pyramidGenerator != null) {
            return this.pyramidGenerator.func_175795_b(pos);
        }
        if (String.valueOf(RuinPieces.RUIN).equals(structureName) && this.ruinGenerator != null) {
            return this.ruinGenerator.func_175795_b(pos);
        }
        if (String.valueOf(TombPieces.TOMB).equals(structureName) && this.tombGenerator != null) {
            return this.tombGenerator.func_175795_b(pos);
        }
        if (String.valueOf(GirafiTombPieces.GIRAFI_TOMB).equals(structureName) && this.girafiTomb != null) {
            return this.girafiTomb.func_175795_b(pos);
        }
        if (String.valueOf(LighthousePieces.LIGHTHOUSE).equals(structureName) && this.lighthouse != null) {
            return this.lighthouse.func_175795_b(pos);
        }
        return false;
    }

    @Nullable
    public BlockPos func_180513_a(@Nonnull World world, @Nonnull String structureName, @Nonnull BlockPos pos, boolean findUnexplored) {
        if (String.valueOf(MapGenAtumMineshaft.MINESHAFT).equals(structureName) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_180706_b(world, pos, findUnexplored);
        }
        if (String.valueOf(PyramidPieces.PYRAMID).equals(structureName) && this.pyramidGenerator != null) {
            return this.pyramidGenerator.func_180706_b(world, pos, findUnexplored);
        }
        if (String.valueOf(RuinPieces.RUIN).equals(structureName) && this.ruinGenerator != null) {
            return this.ruinGenerator.func_180706_b(world, pos, findUnexplored);
        }
        if (String.valueOf(TombPieces.TOMB).equals(structureName) && this.tombGenerator != null) {
            return this.tombGenerator.func_180706_b(world, pos, findUnexplored);
        }
        if (String.valueOf(LighthousePieces.LIGHTHOUSE).equals(structureName) && this.lighthouse != null) {
            return this.lighthouse.func_180706_b(world, pos, findUnexplored);
        }
        return null;
    }

    public void func_180514_a(@Nonnull Chunk chunk, int x, int z) {
        if (this.mapFeaturesEnabled) {
            if (this.settings.field_177829_w) {
                this.mineshaftGenerator.func_186125_a(this.world, x, z, null);
            }
            if (AtumConfig.PYRAMID_ENABLED) {
                this.pyramidGenerator.func_186125_a(this.world, x, z, null);
            }
            this.ruinGenerator.func_186125_a(this.world, x, z, null);
            this.tombGenerator.func_186125_a(this.world, x, z, null);
            this.girafiTomb.func_186125_a(this.world, x, z, null);
            this.lighthouse.func_186125_a(this.world, x, z, null);
        }
    }
}

