/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.beacon.tileentity;

import com.google.common.collect.Lists;
import com.teammetallurgy.atum.blocks.beacon.RadiantBeaconBlock;
import com.teammetallurgy.atum.init.AtumTileEntities;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AirBlock;
import net.minecraft.block.BedrockBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBeaconBeamColorProvider;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.tileentity.BeaconTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RadiantBeaconTileEntity
extends BeaconTileEntity {
    private List<BeaconTileEntity.BeamSegment> beamSegments = Lists.newArrayList();

    @Nonnull
    public TileEntityType<?> func_200662_C() {
        return AtumTileEntities.RADIANT_BEACON;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void func_73660_a() {
        World world = this.field_145850_b;
        if (world != null) {
            this.updateSegmentColors(world);
        }
    }

    private void updateSegmentColors(World world) {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        this.beamSegments.clear();
        float[] defaultColor = ((DyeColor)world.func_180495_p(this.func_174877_v()).func_177229_b(RadiantBeaconBlock.COLOR)).func_193349_f();
        BeaconTileEntity.BeamSegment beamSegment = new BeaconTileEntity.BeamSegment(defaultColor);
        this.beamSegments.add(beamSegment);
        boolean flag = true;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int height = y + 1; height < 256; ++height) {
            float[] color;
            BlockState state = world.func_180495_p((BlockPos)pos.func_181079_c(x, height, z));
            if (state.func_177230_c() instanceof IBeaconBeamColorProvider) {
                color = ((IBeaconBeamColorProvider)state.func_177230_c()).func_196457_d().func_193349_f();
            } else {
                if (state.func_177230_c() instanceof AirBlock) break;
                if (state.func_200016_a((IBlockReader)world, (BlockPos)pos) >= 15 && !(state.func_177230_c() instanceof BedrockBlock)) {
                    this.beamSegments.clear();
                    break;
                }
                float[] customColor = state.func_177230_c().getBeaconColorMultiplier(state, (IWorldReader)world, (BlockPos)pos, this.func_174877_v());
                if (customColor != null) {
                    color = customColor;
                } else {
                    beamSegment.func_177262_a();
                    continue;
                }
            }
            if (!flag) {
                color = new float[]{(beamSegment.func_177263_b()[0] + color[0]) / 2.0f, (beamSegment.func_177263_b()[1] + color[1]) / 2.0f, (beamSegment.func_177263_b()[2] + color[2]) / 2.0f};
            }
            if (Arrays.equals(color, beamSegment.func_177263_b())) {
                beamSegment.func_177262_a();
            } else {
                beamSegment = new BeaconTileEntity.BeamSegment(color);
                this.beamSegments.add(beamSegment);
            }
            flag = false;
        }
        if (!world.field_72995_K) {
            for (ServerPlayerEntity ServerPlayerEntity2 : world.func_217357_a(ServerPlayerEntity.class, new AxisAlignedBB((double)x, (double)y, (double)z, (double)x, (double)(y - 4), (double)z).func_72314_b(10.0, 5.0, 10.0))) {
                CriteriaTriggers.field_192131_k.func_192180_a(ServerPlayerEntity2, (BeaconTileEntity)this);
            }
        }
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public List<BeaconTileEntity.BeamSegment> func_174907_n() {
        return this.beamSegments;
    }
}

